% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-app.R
\name{epitweetr_app}
\alias{epitweetr_app}
\title{Run the epitweetr Shiny app}
\usage{
epitweetr_app(data_dir = NA)
}
\arguments{
\item{data_dir}{Path to the 'data directory' containing application settings, models and collected tweets.
If not provided the system will try to reuse the existing one from last session call of \code{\link{setup_config}} or use the EPI_HOME environment variable, default: NA}
}
\value{
The Shiny server object containing the launched application
}
\description{
Open the epitweetr Shiny app, used to setup the search loop, the detect loop and to visualise the outputs.
}
\details{
The epitweetr app is the user entry point to the epitweetr package. This application will help the user to setup the tweet collection process, manage all settings, 
see the interactive dashboard visualisations, export them to Markdown or PDF, and setup the alert emails.

All its functionality is described on the epitweetr vignette.
}
\examples{
if(FALSE){
   #Running the epitweetr app
   library(epitweetr)
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())
   epitweetr_app()
}
}
\seealso{
\code{\link{search_loop}}

 \code{\link{detect_loop}}
}
