% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{create_snapshot}
\alias{create_snapshot}
\title{Snapshot of your epitweetr installation}
\usage{
create_snapshot(
  destination_dir,
  types = c("settings", "dependencies", "machine-learning", "aggregations", "tweets",
    "logs"),
  tweets_period = get_aggregated_period(),
  aggregated_period = get_aggregated_period(),
  compress = TRUE,
  progress = function(v, m) message(paste(round(v * 100, 2), m))
)
}
\arguments{
\item{destination_dir, }{character(1) vector with the path of the destination folder to produce the snapshot}

\item{types, }{character vector indicating the types of data to include on a snapshot. Some of: "settings", "dependencies", "machine-learning", "aggregations", "tweets", "logs"}

\item{tweets_period, }{date(2) start and end dates to filter tweets to include on snapshot (if selected)}

\item{aggregated_period, }{date(2) start and end dates to filter time series to include on snapshot (if selected)}

\item{compress, }{logical(1) whether to compress or not the output file}

\item{progress, }{function to report progress during execution.}
}
\value{
Nothing
}
\description{
Creates a snapshot file of your epitweetr installation folder. This can include all or a subset of the data files.
}
\details{
This function can be used to create a a portable file to move your epitweetr installation in a single file, to backup your data, to archive your old data or to send information to technical team in order to reproduce an observed issue.
Different kinds of data can be included on the snapshot depending on the type of parameter. Possible values are:
- 'settings': Including all setting files of your installation (excluding passwords)
- 'dependencies': All jars and winutils.exe on windows installations
- 'machine-learning': All trained models and vectors and training data (this can include tweet text which is personal data)
- 'aggregations': Epitweetr aggregated time series
- 'tweets': Tweets collected by epitweetr
- 'logs': Log files produced automatically on windows task scheduler tasks.
}
\examples{
if(FALSE){
   #importing epitweer
   library(epitweetr)
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())
   #creating a compressed snapshot for settings and logs
   create_snapshot(getwd(), c("settings","dependencies"), compress = TRUE)
}
}
