% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global-actions.R
\name{global-actions}
\alias{global-actions}
\alias{globalaction_tool}
\alias{epiworld_globalaction_set_param}
\alias{epiworld_globalaction_tool}
\alias{epiworld_globalaction_tool_logit}
\alias{epiworld_globalaction}
\alias{actions}
\alias{globalaction_tool_logit}
\alias{globalaction_set_params}
\alias{globalaction_fun}
\alias{add_global_action}
\title{Global Actions}
\usage{
globalaction_tool(tool, prob, name = get_name_tool(tool), day = -99)

globalaction_tool_logit(
  tool,
  vars,
  coefs,
  name = get_name_tool(tool),
  day = -99
)

globalaction_set_params(
  param,
  value,
  name = paste0("Set ", param, " to ", value),
  day = -99
)

globalaction_fun(fun, name = deparse(substitute(fun)), day = -99)

add_global_action(model, action)
}
\arguments{
\item{tool}{An object of class \link{tool}.}

\item{prob}{Numeric scalar. A probability between 0 and 1.}

\item{name}{Character scalar. The name of the action.}

\item{day}{Integer. The day (step) at which the action is executed (see details).}

\item{vars}{Integer vector. The position of the variables in the model.}

\item{coefs}{Numeric vector. The coefficients of the logistic regression.}

\item{param}{Character scalar. The name of the parameter to be set.}

\item{value}{Numeric scalar. The value of the parameter.}

\item{fun}{Function. The function to be executed.}

\item{model}{An object of class \link{epiworld_model}.}

\item{action}{A global action.}
}
\value{
\itemize{
\item The \code{globalaction_set_params} function returns an object of class
\link{epiworld_globalaction_set_param} and \link{epiworld_globalaction}.
\item \code{globalaction_tool} returns an object of class
\link{epiworld_globalaction_tool} and \link{epiworld_globalaction}.
\item \code{globalaction_tool_logit} returns an object of class
\link{epiworld_globalaction_tool_logit} and \link{epiworld_globalaction}.
}

\itemize{
\item The function \code{add_global_action} returns the model with the added
action.
}
}
\description{
Global actions are functions that are executed at each time step of the
simulation. They are useful for implementing interventions, such as
vaccination, isolation, and social distancing by means of tools.
}
\details{
The function \code{globalaction_tool_logit} allows to specify a logistic
regression model for the probability of using a tool. The model is specified
by the vector of coefficients \code{coefs} and the vector of variables \code{vars}.
\code{vars} is an integer vector indicating the position of the variables in the
model.

The function \code{globalaction_set_param} allows to set a parameter of
the model. The parameter is specified by its name \code{param} and the value by
\code{value}.

The function \code{globalaction_fun} allows to specify a function to be
executed at a given day. The function object must receive an object of class
\link{epiworld_model} as only argument.

The function \code{add_global_action} adds a global action to a model.
The model checks for actions to be executed at each time step. If the added
action matches the current time step, the action is executed. When \code{day} is
negative, the action is executed at each time step. When \code{day} is positive,
the action is executed at the specified time step.
}
\examples{
# Simple model
model_sirconn <- ModelSIRCONN(
  name                = "COVID-19",
  n                   = 10000,
  prevalence          = 0.01,
  contact_rate        = 5,
  transmission_rate   = 0.4,
  recovery_rate       = 0.95
)

# Creating a tool
epitool <- tool(
  name = "Vaccine",
  susceptibility_reduction = .9,
  transmission_reduction = .5,
  recovery_enhancer = .5, 
  death_reduction = .9
)


# Adding a global action
vaccine_day_20 <- globalaction_tool(epitool, .2, day = 20)
add_global_action(model_sirconn, vaccine_day_20)

# Running and printing
run(model_sirconn, ndays = 40, seed = 1912)
model_sirconn
plot_incidence(model_sirconn)

# Example 2: Changing the contact rate -------------------------------------
model_sirconn2 <- ModelSIRCONN(
  name                = "COVID-19",
  n                   = 10000,
  prevalence          = 0.01,
  contact_rate        = 5,
  transmission_rate   = 0.4,
  recovery_rate       = 0.95
)

closure_day_10 <- globalaction_set_params("Contact rate", 0, day = 10)
add_global_action(model_sirconn2, closure_day_10)

# Running and printing
run(model_sirconn2, ndays = 40, seed = 1912)
model_sirconn2
plot_incidence(model_sirconn2)
# Example using `globalaction_fun` to record the state of the
# agents at each time step.

# We start by creating an SIR connected model
model <- ModelSIRCONN(
  name              = "SIR with Global Saver",
  n                 = 1000,
  prevalence        = 0.01,
  contact_rate      = 5,
  transmission_rate = 0.4,
  recovery_rate     = 0.3
  )

# We create the object where the history of the agents will be stored
agents_history <- NULL

# This function prints the total number of agents in each state
# and stores the history of the agents in the object `agents_history`
hist_saver <- function(m) {
  
  message("Today's totals are: ", paste(get_today_total(m), collapse = ", "))

  # We use the `<<-` operator to assign the value to the global variable
  # `agents_history` (see ?"<<-")
  agents_history <<- cbind(
    agents_history,
    get_agents_states(m)
    )
    
}
}
\seealso{
epiworld-model
}
