% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-methods.R
\name{epiworld-methods}
\alias{epiworld-methods}
\alias{queuing_on}
\alias{epiworld_model}
\alias{queuing_off}
\alias{verbose_off}
\alias{verbose_on}
\alias{run}
\alias{summary.epiworld_model}
\alias{get_states}
\alias{get_param}
\alias{set_param}
\alias{set_name}
\alias{get_name}
\alias{get_n_viruses}
\alias{get_n_tools}
\alias{get_ndays}
\alias{get_n_replicates}
\alias{size}
\alias{set_agents_data}
\alias{get_agents_data_ncols}
\alias{get_virus}
\alias{get_tool}
\alias{initial_states}
\alias{clone_model}
\title{Methods for epiworldR objects}
\usage{
queuing_on(x)

queuing_off(x)

verbose_off(x)

verbose_on(x)

run(model, ndays, seed = sample.int(10000, 1))

\method{summary}{epiworld_model}(object, ...)

get_states(x)

get_param(x, pname)

set_param(x, pname, pval)

set_name(x, mname)

get_name(x)

get_n_viruses(x)

get_n_tools(x)

get_ndays(x)

get_n_replicates(x)

size(x)

set_agents_data(model, data)

get_agents_data_ncols(model)

get_virus(model, virus_pos)

get_tool(model, tool_pos)

initial_states(model, proportions)

clone_model(model)
}
\arguments{
\item{x}{An object of class \code{epiworld_model}.}

\item{model}{Model object.}

\item{ndays}{Number of days (steps) of the simulation.}

\item{seed}{Seed to set for initializing random number generator.}

\item{object}{Object of class \code{epiworld_model}.}

\item{...}{Additional arguments.}

\item{pname}{String. Name of the parameter.}

\item{pval}{Numeric. Value of the parameter.}

\item{mname}{String. Name of the model.}

\item{data}{A numeric matrix.}

\item{virus_pos}{Integer. Relative location (starting from 0) of the virus
in the model}

\item{tool_pos}{Integer. Relative location (starting from 0) of the tool
in the model}

\item{proportions}{Numeric vector. Proportions in which agents will be
distributed (see details).}
}
\value{
\itemize{
\item The \code{verbose_on} and \code{verbose_off} functions return the same model, however
\code{verbose_off} returns the model with no progress bar.
}

\itemize{
\item The \code{run} function returns the simulated model of class \code{epiworld_model}.
}

\itemize{
\item The \code{summary} function prints a more detailed view of the model, and returns the same model invisibly.
}

\itemize{
\item The \code{get_states} function returns the unique states found in a model.
}

\itemize{
\item The \code{get_param} function returns a selected parameter from the model object
of class \code{epiworld_model}.
}

\itemize{
\item The \code{set_param} function does not return a value but instead alters a
parameter value.
}

\itemize{
\item The \code{set_name} function does not return a value but instead alters an object
of \code{epiworld_model}.
}

\itemize{
\item \code{get_name} returns the name of the model.
}

\itemize{
\item \code{get_n_viruses} returns the number of viruses of the model.
}

\itemize{
\item \code{get_n_tools} returns the number of tools of the model.
}

\itemize{
\item \code{get_ndays} returns the number of days of the model.
}

\itemize{
\item \code{get_n_replicates} returns the number of replicates of the model.
}

\itemize{
\item \code{size.epiworld_model} returns the number of agents in the model.
}

\itemize{
\item The 'set_agents_data' function returns an object of class DataFrame.
}

\itemize{
\item 'get_agents_data_ncols' returns the number of columns in the model dataframe.
}

\itemize{
\item 'get_virus' returns a \link{virus}.
}

\itemize{
\item \code{get_tool} returns a \link{tool}.
}

\itemize{
\item \code{inital_states} returns the model with an updated initial state.
}

\itemize{
\item \code{clone_model} returns a copy of the model.
}
}
\description{
The functions described in this section are methods for objects of class
\code{epiworld_model}. Besides of printing and plotting, other methods provide
access to manipulate model parameters, getting information about the model
and running the simulation.
}
\details{
The \code{verbose_on} and \code{verbose_off} functions activate and deactivate printing
progress on screen, respectively. Both functions return the model (\code{x}) invisibly.

\code{epiworld_model} objects are pointers to an underlying C++ class
in \code{epiworld}. To generate a copy of a model, use \code{clone_model}, otherwise,
the assignment operator will only copy the pointer.
}
\examples{

model_sirconn <- ModelSIRCONN(
name                = "COVID-19",
n                   = 10000,
prevalence          = 0.01,
contact_rate        = 5,
transmission_rate   = 0.4,
recovery_rate       = 0.95
)

# Queuing - If you wish to implement the queuing function, declare whether 
# you would like it "on" or "off", if any. 
queuing_on(model_sirconn)
queuing_off(model_sirconn)
run(model_sirconn, ndays = 100, seed = 1912)

# Verbose - "on" prints the progress bar on the screen while "off" 
# deactivates the progress bar. Declare which function you want to implement, 
# if any. 
verbose_on(model_sirconn)
verbose_off(model_sirconn)
run(model_sirconn, ndays = 100, seed = 1912)

get_states(model_sirconn) # Returns all unique states found within the model.

get_param(model_sirconn, 'Contact rate') # Returns the value of the selected 
                                         # parameter within the model object.
                                         # In order to view the parameters, 
                                         # run the model object and find the 
                                         # "Model parameters" section. 

set_param(model_sirconn, 'Contact rate', 2) # Allows for adjustment of model 
                                            # parameters within the model 
                                            # object. In this example, the 
                                            # Contact rate parameter is 
                                            # changed to 2. You can now rerun 
                                            # the model to observe any 
                                            # differences.
                                            
set_name(model_sirconn, 'My Epi-Model') # This function allows for setting 
                                        # a name for the model. Running the 
                                        # model object, the name of the model
                                        # is now reflected next to "Name of 
                                        # the model". 
                                        
get_name(model_sirconn) # Returns the set name of the model. 

get_n_viruses(model_sirconn) # Returns the number of viruses in the model. 
                              # In this case, there is only one virus:
                              # "COVID-19". 
                              
get_n_tools(model_sirconn) # Returns the number of tools in the model. In 
                           # this case, there are zero tools.  
                           
get_ndays(model_sirconn) # Returns the length of the simulation in days. This
                         # will match "ndays" within the "run" function. 
                         
get_n_replicates(model_sirconn) # Returns the number of replicates of the 
                                # model. 
                                
size(model_sirconn) # Returns the population size in the model. In this case, 
                    # there are 10,000 agents in the model. 
# Set Agents Data
# First, your data matrix must have the same number of rows as agents in the 
# model. Below is a generated matrix which will be passed into the 
# "set_agents_data" function. 
data <- matrix(data=runif(20000, min=0, max=100), nrow=10000, ncol=2)                   
set_agents_data(model_sirconn, data)
get_agents_data_ncols(model_sirconn) # Returns number of columns 

get_virus(model_sirconn, 0) # Returns information about the first virus in 
                            # the model (index begins at 0).

add_tool(model_sirconn, tool("Vaccine", .9, .9, .5, 1, prevalence = 0.5, as_prop = TRUE))                            
get_tool(model_sirconn, 0) # Returns information about the first tool in the 
                           # model. In this case, there are no tools so an 
                           # error message will occur. 
}
