% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netcdf.R
\name{extract_data}
\alias{extract_data}
\title{Extract data}
\usage{
extract_data(
  coord,
  years = NULL,
  unit = FALSE,
  out_dir = NULL,
  by = NULL,
  keep = is.null(out_dir),
  compress = 100
)
}
\arguments{
\item{coord}{An \code{epw_cmip6_coord} object created using \code{\link[=match_coord]{match_coord()}}}

\item{years}{An integer vector indicating the target years to be included in
the data file. All other years will be excluded. If \code{NULL}, no
subsetting on years will be performed. Default: \code{NULL}.}

\item{unit}{If \code{TRUE}, units will be added to values using
\code{\link[units:set_units]{units::set_units()}}.}

\item{out_dir}{The directory to save extracted data using \code{\link[fst:write_fst]{fst::write_fst()}}.
If \code{NULL}, all data will be kept in memory by default. Default: \code{NULL}.}

\item{by}{A character vector of variable names used to split data
during extraction. Should be a subset of:
\itemize{
\item \code{"experiment"}: root experiment identifiers
\item \code{"source"}: model identifiers
\item \code{"variable"}: variable identifiers
\item \code{"activity"}: activity identifiers
\item \code{"frequency"}: sampling frequency
\item \code{"variant"}: variant label
\item \code{"resolution"}: approximate horizontal resolution
}

If \code{NULL} and \code{out_dir} is given, file name \code{data.fst} will be used. Default:
\code{NULL}.}

\item{keep}{Whether keep extracted data in memory. Default: \code{TRUE} if
\code{out_dir} is \code{NULL}, and \code{FALSE} otherwise.}

\item{compress}{A single integer in the range 0 to 100, indicating the amount
of compression to use. Lower values mean larger file sizes. Default:
\code{100}.}
}
\value{
An \code{epw_cmip6_data} object, which is basically a list of 3 elements:
\itemize{
\item \code{epw}: An \link[eplusr:Epw]{eplusr::Epw} object whose longitude and latitute are used to
extract CMIP6 data. It is the same object as created in \code{\link[=match_coord]{match_coord()}}
\item \code{meta}: A list containing basic meta data of input EPW, including \code{city},
\code{state_province}, \code{country}, \code{latitute} and \code{longitude}.
\item \code{data}: An empty \code{\link[data.table:data.table]{data.table::data.table()}} if \code{keep} is \code{FALSE} or a
\code{\link[data.table:data.table]{data.table::data.table()}} of 12 columns if \code{keep} is \code{TRUE}:\tabular{rlll}{
   No. \tab Column \tab Type \tab Description \cr
   1 \tab \code{activity_drs} \tab Character \tab Activity DRS (Data Reference Syntax) \cr
   2 \tab \code{institution_id} \tab Character \tab Institution identifier \cr
   3 \tab \code{source_id} \tab Character \tab Model identifier \cr
   4 \tab \code{experiment_id} \tab Character \tab Root experiment identifier \cr
   5 \tab \code{member_id} \tab Character \tab A compound construction from \code{sub_experiment_id} and \code{variant_label} \cr
   6 \tab \code{table_id} \tab Character \tab Table identifier \cr
   7 \tab \code{lat} \tab Double \tab Latitude of extracted location \cr
   8 \tab \code{lon} \tab Double \tab Latitude of extracted location \cr
   9 \tab \code{variable} \tab Character \tab Variable identifier \cr
   10 \tab \code{description} \tab Character \tab Variable long name \cr
   11 \tab \code{units} \tab Character \tab Units of variable \cr
   12 \tab \code{value} \tab Double \tab Start date and time of simulation \cr
}

}
}
\description{
\code{extract_data()} takes an \code{epw_cmip6_coord} object generated using
\code{\link[=match_coord]{match_coord()}} and extracts CMIP6 data using the coordinates and years of
interest specified.
}
\details{
\code{extract_data()} uses \link[future.apply:future_lapply]{future.apply}
underneath. You can use your preferable \link[future:plan]{future} backend to
speed up data extraction in parallel. By default, \code{extract_data()} uses
\link[future:sequential]{future::sequential} backend, which runs things in sequential.
}
\examples{
\dontrun{
coord <- match_coord("path_to_an_EPW")
extract_data(coord, years = 2030:2060)
}
}
