% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_aux.R
\name{.summary_cts_by_fu}
\alias{.summary_cts_by_fu}
\title{Wrapper to summarise a continuous variable by follow-up (FU)}
\usage{
.summary_cts_by_fu(df, name_v)
}
\arguments{
\item{df}{A data frame containing the FU and continuous variable of interest. The dataset must contain an ordered `fu` variable.}

\item{name_v}{A character string with the name of the continuous variable in `df` to be summarised.}
}
\value{
Data frame with one row for each statistic and one column for each FU.
}
\description{
This function summarizes a continuous variable for each follow-up (FU) and calculates various statistics such as mean, standard deviation, median, mode, kurtosis, skewness, minimum, maximum, range, and number of observations. It also reports the total sample size and the number (and proportion) of missing values for each FU. 
The input `df` must contain an ordered FU variable and the continuous variable of interest. 
The name of the continuous variable must be specified using `name_v`. 
The wrapper is used in Table 3.1 (for VAS) or Table 4.2 (for EQ-5D utility)
}
\examples{
df <- data.frame(fu = c(1,1,2,2,3,3), 
                 vas = c(7,8,9,NA,7,6))
.summary_cts_by_fu(df, name_v = "vas")
}
