% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degreedist.R
\name{mixingmatrix.egor}
\alias{mixingmatrix.egor}
\alias{mixingmatrix}
\title{Summarizing the mixing among groups in an egocentric dataset}
\usage{
\method{mixingmatrix}{egor}(object, attrname, rowprob = FALSE, weight = TRUE, ...)
}
\arguments{
\item{object}{A \code{\link{egor}} object.}

\item{attrname}{A character vector containing the name of the network
attribute whose mixing matrix is wanted.}

\item{rowprob}{Whether the counts should be normalized by row sums. That is,
whether they should be proportions conditional on the ego's group.}

\item{weight}{Whether sampling weights should be incorporated into
the calculation (\code{TRUE}, the default) or ignored (\code{FALSE}).}

\item{...}{Additional arguments, currently unused.}
}
\value{
A matrix with a row and a column for each level of \code{attrname}.

Note that, unlike \code{\link[network]{mixingmatrix}}, what is counted are
\emph{nominations}, not ties. This means that under an egocentric census,
the diagonal of \code{mixingmatrix.egor} will be twice that returned by
\code{\link[network]{mixingmatrix}} for the original undirected network.
}
\description{
A \code{\link[network]{mixingmatrix}} method for
\code{\link{egor}} objects, to return counts of how often a ego
of each group nominates an alter of each group.
}
\examples{

data(faux.mesa.high)
fmh.ego <- as.egor(faux.mesa.high)

(mm <- mixingmatrix(faux.mesa.high,"Grade"))
(mm.ego <- mixingmatrix(fmh.ego,"Grade"))

}
\seealso{
\code{\link[network]{mixingmatrix}}, \code{\link[ergm]{nodemix-ergmTerm}},
\code{\link[ergm.ego]{summary}} method for egocentric data
}
