% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmhfit.R
\docType{data}
\name{fmhfit}
\alias{fmhfit}
\title{Fitted ergm.ego model object}
\format{
An object of class \code{ergm.ego}.
}
\description{
This is an object with a fitted model to \code{faux.mesa.high} data using the code
shown below in the Examples section.
}
\examples{
\dontrun{
data(faux.mesa.high)
fmh.ego <- egor::as.egor(faux.mesa.high)
fmhfit <- ergm.ego(
  fmh.ego ~ edges + degree(0:3) + 
    nodefactor("Race") + nodematch("Race")
  + nodefactor("Sex")+nodematch("Sex")
  + absdiff("Grade") + gwesp(0, fix=TRUE), 
  popsize = network.size(faux.mesa.high),
  control = control.ergm.ego(
    ergm = control.ergm(parallel=2)
  )
)
}
}
