% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.eta.R, R/ergm.etagrad.R,
%   R/ergm.etagradmult.R
\name{ergm.eta}
\alias{ergm.eta}
\alias{ergm.etagrad}
\alias{ergm.etagradmult}
\title{Operations to map curved \code{\link[=ergm]{ergm()}} parameters onto canonical parameters}
\usage{
ergm.eta(theta, etamap)

ergm.etagrad(theta, etamap)

ergm.etagradmult(theta, v, etamap)
}
\arguments{
\item{theta}{the curved model parameters}

\item{etamap}{the list of values that describes the theta -> eta
mapping, usually attached as \verb{$etamap} element of an \code{\link{ergm_model}}
object. At this time, it is a list with the following elements:
\describe{
\item{\code{canonical}}{ a numeric vector whose \code{i}th entry specifies whether the \code{i}th component of theta is canonical (via non-negative integers) or curved (via zeroes)}
\item{\code{offsetmap}}{ a logical vector whose \code{i}th entry tells whether the ith coefficient of the canonical parameterization was "offset", i.e fixed}
\item{\code{offset}}{ a logical vector whose ith entry tells whether the ith model term was offset/fixed}
\item{\code{offsettheta}}{ a logical vector whose ith entry tells whether the ith curved theta coeffient was offset/fixed;}
\item{\code{curved}}{ a list with one component per curved EF term in
the model containing \describe{
\item{\code{from}}{ the indices of the curved theta parameter that are to be mapped from}
\item{\code{to}}{ the indices of the canonical eta parameters to be mapped to}
\item{\code{map}}{ the map provided by \code{\link{InitErgmTerm}}}
\item{\code{gradient}}{ the gradient function provided by \code{\link{InitErgmTerm}}}
\item{\code{cov}}{ optional additional covariates to be passed to the map and the gradient functions }
\item{\code{etalength}}{ the length of the eta vector}
}
}
}}

\item{v}{a vector of the same length as the vector of mapped eta
parameters}
}
\value{
For \code{ergm.eta}, the canonical eta parameters as mapped
from theta.

For \code{ergm.etagrad}, a matrix of the gradient of eta
with respect to theta.

For \code{ergm.etagradmult}, the vector that is the product
of the gradient of eta and \code{v}.
}
\description{
The \code{ergm.eta} function calculates and returns eta, mapped
from theta using the \code{etamap} object, usually attached as the
\verb{$etamap} element of an \code{\link{ergm_model}} object.

The \code{ergm.etagrad} function caculates and returns
the gradient of eta mapped from theta using the etamap object
created by \code{ergm.etamap}. If the gradient is only intended
to be a multiplier for some vector, the more efficient
\code{ergm.etagradmult} is recommended.

The \code{ergm.etagradmult} function calculates and
returns the product of the gradient of eta with a vector \code{v}.
}
\details{
These functions are mainly important in the case of curved exponential family
models, i.e., those in which the parameter of interest (theta) is not a
linear function of the natural parameters (eta) in the exponential-family
model. In non-curved models, we may assume without loss of generality that
eta(theta)=theta.

A succinct description of how eta(theta) is incorporated into an ERGM is
given by equation (5) of Hunter (2007).  See Hunter and Handcock (2006) and
Hunter (2007) for further details about how eta and its derivatives are used
in the estimation process.
}
\references{
\itemize{ \item Hunter, D. R. and M. S. Handcock
(2006).  Inference in curved exponential family models for
networks. \emph{Journal of Computational and Graphical
Statistics}, 15: 565--583.

\item Hunter, D. R. (2007). Curved exponential family models for social
networks. \emph{Social Networks}, 29: 216--230.  }
}
\seealso{
\code{\link{ergm-terms}}
}
\keyword{internal}
