% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.operator.R,
%   R/InitWtErgmTerm.operator.R
\name{Prod-ergmTerm}
\alias{Prod-ergmTerm}
\alias{InitErgmTerm.Prod}
\alias{InitWtErgmTerm.Prod}
\title{A product (or an arbitrary power combination) of one or more formulas}
\usage{
# binary: Prod(formulas, label)

# valued: Prod(formulas, label)
}
\arguments{
\item{formulas}{a list (constructed using \code{\link[=list]{list()}} or \code{\link[=c]{c()}}) of \code{\link[=ergm]{ergm()}}-style formulas whose RHS gives the statistics to be evaluated, or a single formula.

If a formula in the list has an LHS, it is interpreted as follows:
\itemize{
\item a numeric scalar: Network statistics of this formula will be exponentiated by this.
\item a numeric vector: Corresponding network statistics of this formula will be exponentiated by this.
\item a numeric matrix: Vector of network statistics will be exponentiated by this using the same pattern as matrix multiplication.
\item a character string: One of several predefined multiplicative combinations. Currently supported presets are as follows:
\itemize{
\item \code{"prod"}: Network statistics of this formula will be multiplied together; equivalent to \code{matrix(1,1,p)} , where \code{p} is the length of the network statistic vector.
\item \code{"geomean"}: Network statistics of this formula will be geometrically averaged; equivalent to \code{matrix(1/p,1,p)} , where \code{p} is the length of the network statistic vector.
}
}}

\item{label}{used to specify the names of the elements of the resulting term product vector. If \code{label} is a character vector of length 1,
it will be recycled with indices appended. If a function is specified, \code{formulas} parameter names are extracted and their list of character vectors is passed \code{label}.}
}
\description{
This operator evaluates a list of formulas whose corresponnding RHS
statistics will be multiplied elementwise. They are required to be nonnegative.
}
\details{
Note that each formula must either produce the same number of
statistics or be mapped through a matrix to produce the same
number of statistics.

A single formula is also permitted. This can be useful if one
wishes to, say, scale or multiply together the statistics returned by a formula.

Offsets are ignored unless there is only one formula and the transformation only scales the statistics (i.e., the effective transformation matrix is diagonal).

Curved models are supported, subject to some limitations. In particular, the first model's etamap will be used, overwriting the others. If \code{label} is not of length 1, it should have an \code{attr} -style attribute \code{"curved"} specifying the names for the curved parameters.
}
\note{
The current implementation piggybacks on the \code{Log} , \code{Exp} , and \code{Sum} operators, essentially \code{Exp(~Sum(~Log(formula), label))} . This may result in loss of precision, particularly for extremely large or small statistics. The implementation may change in the future.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "Prod", "subsection")}
}
\concept{operator}
