% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_intervals.R
\name{acc_intervals}
\alias{acc_intervals}
\title{Accuracy of Error intervals}
\usage{
acc_intervals(interv, errors, f = function(x, y) {     abs(x - y) },
  tol = 10^-8)
}
\arguments{
\item{interv}{error interval.}

\item{errors}{set of errors.}

\item{f}{error function to be used to compute error between real \code{x}
(\code{interv}) and predicted \code{y} (\code{errors}) values. See also 'Details'.}

\item{tol}{used to normalize residual values to (0,1) when beta is the
assumed distribution. See also 'Details'.}
}
\value{
Returns an object of class \code{c("measure","list")} with information of
the interval accuracy.
}
\description{
\code{int_intervals} computes the real accuracy of a given error intervals
for a particular set of errors and a particular error function.
}
\details{
\code{f} must be a function that takes two arguments, \code{x} and \code{y},
and return a numeric value.

The formula used to normalize residual values to (0,1) when a Beta distribution is
assumed is \eqn{\frac{|\phi|}{max{|\phi|}+tol}}{|\phi|*(max(|\phi|)+tol)^(-1)}.
}
\examples{
interv<-int_gau(rnorm(1000),0.1)
acc_intervals(interv,rnorm(1000))
acc_intervals(interv,rnorm(1000),function(x,y){x-y})
}
\author{
Jesus Prada, \email{jesus.prada@estudiante.uam.es}
}
\references{
Link to the scientific paper

Prada, Jesus, and Jose Ramon Dorronsoro. "SVRs and Uncertainty Estimates in Wind 
Energy Prediction." Advances in Computational Intelligence. Springer International 
Publishing, 2015. 564-577,

with theoretical background for this package is provided below.

\url{http://link.springer.com/chapter/10.1007/978-3-319-19222-2_47}
}
\seealso{
\link{measure} \link{error_interval}
}

