% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enp.R
\name{enp}
\alias{enp}
\title{Effective Number of Parties}
\usage{
enp(esapsObject, summary = FALSE)
}
\arguments{
\item{esapsObject}{An \code{esaps} class object. Function: \code{\link{esaps_object}}.}

\item{summary}{Summary of the data by country, by default it is \code{FALSE}.}
}
\description{
The Effective Number of Parties (ENP) is an index developed by
    \href{http://bit.ly/2oYU4dV}{Laakso and Taagepera (1979)} that allows to
    count the relevant parties in a party system. The formula consists on
    dividing one over the sum of the squares of the proportions (votes or seats)
    that the parties obtain in an electoral instance.
}
\examples{
votes <- list(data.frame(country = rep("ARG", 3),
                         year = c(1995, 2000, 2005),
                         party_A = c(40,10,20),
                         party_B = c(35,20,40),
                         party_C = c(25,70,40)),
              data.frame(country = rep("URY", 4),
                         year = c(1995, 2000, 2005, 2010),
                         party_A = c(30,30,20,20),
                         party_B = c(30,50,40, 30),
                         party_C = c(30,10,30, 25),
                         party_D = c(10,10,10,25)),
              data.frame(country = rep("BRA", 2),
                         year = c(1993, 1998),
                         party_A = c(30, 55),
                         party_B = c(70, 45)))

votes <- esaps_object(dataset = votes, name.country = "country", name.year = "year")
en_party <- enp(votes, summary = TRUE)
}
