% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dose_paths.R
\name{get_dose_paths}
\alias{get_dose_paths}
\title{Calculate future dose paths.}
\usage{
get_dose_paths(selector_factory, cohort_sizes, ...)
}
\arguments{
\item{selector_factory}{Object of type \code{\link{selector_factory}}.}

\item{cohort_sizes}{Integer vector representing sizes of}

\item{...}{Extra args are passed onwards.}
}
\value{
Object of type \code{\link{dose_paths}}.
}
\description{
A dose-escalation design exists to select doses in response to observed
outcomes. The entire space of possible responses can be calculated to show
the behaviour of a design in response to all feasible outcomes. This function
performs that task.
}
\examples{
# Calculate paths for a 3+3 design for the next two cohorts of three patients
paths <- get_three_plus_three(num_doses = 5) \%>\%
  get_dose_paths(cohort_sizes = c(3, 3))
}
