% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_psdpanels.R
\name{aux_psdpanels}
\alias{aux_psdpanels}
\title{Generate spectrogram panels for a seismic network}
\usage{
aux_psdpanels(station, component = "BHZ", period, span = 1, input_dir,
  output_dir, cpu, aggregate = c(1, 5), n_dates = 2000, jpg_dim = c(4444,
  2500, 300, 90), verbose = FALSE, ...)
}
\arguments{
\item{station}{\code{Character} value, seismic station ID, which must
correspond to the ID in the file name of the data directory structure 
(cf. \code{aux_organisecubefiles}).}

\item{component}{\code{Character} value, seismic component, which must
correspond to the component name in the file name of the data directory  
structure (cf. \code{aux_organisecubefiles}). Default is 
\code{"BHZ"} (vertical component).}

\item{period}{\code{POSIXct} vector of length two, time period to be 
processed.}

\item{span}{\code{Numeric} vector, time span per PSD in hours. Value can 
range between 1 and 24. For each time span a separate jpeg-file will be 
produced. Default is \code{1} hour.}

\item{input_dir}{\code{Character} value, path to directory where the 
seismic files are stored.}

\item{output_dir}{\code{Character} value, path to directory where PSD
image files are saved to.}

\item{cpu}{\code{Numeric} value, fraction of CPUs to use for parallel 
processing. If omitted, one CPU is used.}

\item{aggregate}{\code{Numeric} vector of length two, aggregation factors 
for the processed PSD matrics. First entry denotes time aggregation, 
second entry frequency aggregation. Default is \code{c(1, 5)}.}

\item{n_dates}{\code{Numeric} value, final number of spectra per output 
PSD. Default is \code{2000}.}

\item{jpg_dim}{\code{Numeric} vector of length four, JPEG image properties 
in the form \code{c(width, height, resolution, quality)}. Default is 
\code{c(4444, 2500, 300, 90)}.}

\item{verbose}{\code{Logical} value, optional screen output of processing 
progress. Default is \code{FALSE}.}

\item{\dots}{Additional arguments passed to different functions. See 
details section for default values.}
}
\value{
A set of JPEG images wirtten to disk
}
\description{
The function generates a set of spectrogram (PSD) panels on single to  
several hours basis. It depends on seismic files being organised in a 
coherent structure as, for example generated by
\code{aux_organisecubefiles}. The function is similar to 
\code{aux_psdsummary} but arranges PSDs of all stations by time, rather 
than creating individual PSDs by time and station.
}
\details{
The function calls a series of other functions, partly with modified 
default values, which can be changed by the ...-argument. By default, 
the seismic files are imported as eseis objects using 
\code{aux_getevent(..., eseis = TRUE)}. The signals are deconvolved with
\code{signal_deconvolve()} using the default options, i.e., 
\code{sensor = "TC120s"} and \code{logger = "Cube3extBOB"}.
Then, the signals are bandpass filtered with \code{signal_filter}, using 
\code{f = c(1, 90)}. The PSDs are calculated with \code{signal_spectrogram} 
using \code{Welch = TRUE}, \code{window = 30} and \code{window_sub = 15}.

This and all other aux-functions are primarily written for internal use 
in the GFZ Geomorphology Section group members and their usual data 
handling scheme. Thus, they may be of limited use when adopted for other 
scopes. However, many of these functions are internally consistent in 
usage.
}
\examples{

\dontrun{

## PSD generation with minimum input arguments
aux_psdpanels(station = stations$ID, 
              input_dir = "input/")
              
}

}
\author{
Michael Dietze
}
\keyword{eseis}
