% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fixmseed.R
\name{aux_fixmseed}
\alias{aux_fixmseed}
\title{Fix corrupt miniseed files}
\usage{
aux_fixmseed(file, input_dir, output_dir, software)
}
\arguments{
\item{file}{\code{Character} vector, seismic file to process.}

\item{input_dir}{\code{Character} value, path to input directory, i.e., 
the directory where the files to process are located.}

\item{output_dir}{\code{Character} value, path to output directory, i.e., 
the directory where the processed files are written to. This must be 
different from \code{input_dir}.}

\item{software}{\code{Character} value, path to the 'dataselect' library, 
required unless the path to the library is made gobally visible.}
}
\value{
a set of mseed files written to disk.
}
\description{
This function is a wrapper for the library 'dataselect' from IRIS. It 
reads a corrupt mseed file and saves it in fixed state. Therefore, the 
function requires dataselect being installed (see details).
}
\details{
The library 'dataselect' can be downloaded at 
https://github.com/iris-edu/dataselect
and requires compilation (see README file in dataselect directory). The 
function goes back to an email discussion with Gillian Sharer (IRIS team),
many thanks for pointing me at this option to process corrupt mseed files.
}
\examples{

\dontrun{

aux_fixmseed(file = list.files(path = "~/data/mseed", 
                               pattern = "miniseed"), 
                    input_dir = "~/data/mseed",
                    software = "~/software/dataselect-3.17")

}

}
\author{
Michael Dietze
}
\keyword{eseis}
