% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_whiten.R
\name{signal_whiten}
\alias{signal_whiten}
\title{Perform spectral whitening of a signal vector}
\usage{
signal_whiten(data, f, dt)
}
\arguments{
\item{data}{\code{eseis} object, or \code{complex} vector, data set to 
be processed.}

\item{f}{\code{Numeric} vector of length two, frequency window within 
which to normalise. If omitted, the entire bandwidth is normalised.}

\item{dt}{\code{Numeric} value, sampling period. Only needed if the input 
object is not an \code{eseis} object}
}
\value{
\code{Numeric} vector or eseis object, whitened signal vector.
}
\description{
The function normalises the input signal within a given frequency 
window. If a time series is provided, it is converted to the spectral 
domain, whitening is performed, and it is transformed back to the time 
domain.
}
\examples{

## load example data set
data("rockfall")

## whiten data set between 10 and 30 Hz
rockfall_2 <- signal_whiten(data = rockfall_eseis, 
                            f = c(10, 30))
                            
## plot whitened data set
plot(rockfall_2)

}
\author{
Michael Dietze
}
\keyword{eseis}
