% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obj_create.R
\name{obj.create}
\alias{obj.create}
\title{Espadon object creating}
\usage{
obj.create(class = c("", "volume", "struct", "mesh"), alias = "")
}
\arguments{
\item{class}{Character string, representing an espadon class from among
"volume", "struct" or "mesh".}

\item{alias}{Character string, \code{$alias} of the created object.}
}
\value{
Returns a espadon class object (see \link[espadon]{espadon.class}
for class definitions).
}
\description{
The \code{obj.create} function creates an espadon object with
the essential properties it must have.
}
\examples{
# Creation of an espadon mesh of a cube
M <- obj.create (class = "mesh")
M$mesh <- Rvcg::vcgIsotropicRemeshing (Rvcg::vcgBox(),0.5) 
M$nb.faces <- ncol (M$mesh$it)
rgl::wire3d (M$mesh)
}
\seealso{
\link[espadon]{vol.create}, \link[espadon]{struct.create}.
}
