% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_from_bin.R
\name{mesh.from.bin}
\alias{mesh.from.bin}
\title{Creation of a mesh according to a binary volume}
\usage{
mesh.from.bin(
  bin,
  alias = "",
  tol = 1,
  smooth.iteration = 10,
  smooth.type = c("taubin", "laplace", "HClaplace", "fujiLaplace", "angWeight",
    "surfPreserveLaplace"),
  smooth.lambda = 0.5,
  smooth.mu = -0.53,
  smooth.delta = 0.1,
  verbose = FALSE
)
}
\arguments{
\item{bin}{"volume" class object of "binary" modality.}

\item{alias}{Character string, \code{$alias} of the mesh defining
the \code{$alias} of the created object.}

\item{tol}{Tolerance in mm, applied for mesh simplification. See \link[Rvcg]{vcgClean}.}

\item{smooth.iteration}{Number of iterations applied in the smoothing algorithm.
See \link[Rvcg]{vcgSmooth}.}

\item{smooth.type}{character: select smoothing algorithm. Available are "taubin",
"laplace", "HClaplace", "fujiLaplace", "angWeight" (and any sensible abbreviations).
By default, set to "taubin". See \link[Rvcg]{vcgSmooth}.}

\item{smooth.lambda}{numeric: parameter for Taubin smooth. See \link[Rvcg]{vcgSmooth}.}

\item{smooth.mu}{numeric: parameter for Taubin smooth. See \link[Rvcg]{vcgSmooth}.}

\item{smooth.delta}{numeric: parameter for Scale dependent laplacian smoothing
(see reference below).and maximum allowed angle (in radians) for deviation
between normals Laplacian (surface preserving). See \link[Rvcg]{vcgSmooth}.}

\item{verbose}{Boolean, by default set to \code{FALSE}. Allows you to inhibit comments.}
}
\value{
Returns a "mesh" class object. This is a list including the
following 6 elements:
\itemize{
\item \code{$patient}: set to \code{bin$patient}.
\item \code{$patient.bd}: set to \code{bin$patient.bd}.
\item \code{$patient.name}: set to \code{bin$patient.name}.
\item \code{$patient.sex}: set to \code{bin$patient.sex}.
\item \code{$file.basename}: set to "".
\item \code{$file.dirname}: set to "".
\item \code{$object.name}: set to "".
\item \code{$object.alias}: set to the \code{alias} argument of the function.
\item \code{$frame.of.reference}: set to \code{bin$frame.of.reference}.
\item \code{$ref.pseudo} : set to \code{bin$ref.pseudo}.
\item \code{$modality} : set to \code{"mesh"}.
\item \code{$description}: By default, set to \code{paste (bin$object.alias, "mesh")}.
\item \code{$creation.date}: set to \code{Sys.Date}.
\item \code{$nb.faces}: set to the number of faces of the mesh.
\item \code{$mesh}: list of 3 elements defining the mesh:
\tabular{rl}{
\tab - \code{$vb}: array made up of the generalized coordinates (x, y, z, 1) of the vertices of the triangles.\cr
\tab There are as many columns as there are vertices.\cr
\tab - \code{$it}: array of the 3 indices of the vertices forming a triangle, arranged by column.\cr
\tab There are as many columns as there are triangles in the mesh.\cr
\tab - \code{$normals}: array made up of the generalized coordinates (x, y, z, 1) of the normal vectors of each triangle.\cr
\tab There are as many columns as there are vertices.\cr
}
}
}
\description{
The \code{mesh.from.bin} function creates a \code{mesh} class
object from a volume object of "binary" modality.
}
\note{
To compute the mesh, all NA voxels of the binary volume \code{bin} are
set to FALSE. If all voxels are equal to FALSE, the function returns the code {NULL}.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 4
patient <- toy.load.patient (modality = c("ct", "rtstruct"), roi.name = "",
                             dxyz = rep (step, 3))
CT <- patient$ct[[1]]
S <- patient$rtstruct[[1]]

# creation of the patient mesh
bin <- bin.from.roi (CT, struct = S, roi.name = "patient")
mesh.patient <- mesh.from.bin (bin, alias = "patient", verbose = FALSE)
str (mesh.patient)
}
\seealso{
\link[Rvcg]{vcgSmooth}
}
