% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_remove.R
\name{ref.remove}
\alias{ref.remove}
\title{Deletion of a frame of reference in T.MAT}
\usage{
ref.remove(ref.name, T.MAT)
}
\arguments{
\item{ref.name}{Character string, pseudonym of the frame of reference to delete.}

\item{T.MAT}{"t.mat" class object in which the \code{ref.name} frame of
reference is to be deleted.}
}
\value{
Returns a "t.mat" class object, which no longer contains transfer
matrices from or to the ref.pseudo \code{ref.name}.
\link[espadon]{ref.cutplane.add}.
}
\description{
The \code{ref.remove} function removes the management of a frame
of reference in T.MAT.
}
\examples{
# Adding of the reference frame "ref1_60", which is a 60 degree rotation of 
# reference frame "ref1".
orientation <- c (cos (pi / 3), sin (pi / 3), 0, 
                  -sin (pi / 3), cos (pi / 3), 0)

local.Tmat <- ref.add (src.ref = "ref1", orientation = orientation,
                  new.ref.pseudo = "ref1_60")
str(local.Tmat)

# Removal of  "ref1_60"
local.Tmat <- ref.remove (ref.name =  "ref1_60", T.MAT = local.Tmat)
str(local.Tmat)
}
