% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.volume}
\alias{plot.struct}
\alias{plot.mesh}
\title{plot a 2D cut of a 3D object}
\usage{
\method{plot}{volume}(
  x,
  ...,
  view.type = "trans",
  view.coord = NULL,
  flip = FALSE,
  flop = FALSE,
  cut.interpolate = TRUE,
  display.interpolate = FALSE,
  col = grey.colors(255, start = 0, end = 1),
  breaks = NULL,
  sat.transp = FALSE
)

\method{plot}{struct}(
  x,
  ...,
  view.type = "trans",
  view.coord = NULL,
  flip = FALSE,
  flop = FALSE,
  roi.name = NULL,
  roi.sname = NULL,
  roi.idx = NULL,
  back.dxyz = c(0.5, 0.5, x$thickness)
)

\method{plot}{mesh}(
  x,
  ...,
  view.type = "trans",
  view.coord = NULL,
  flip = FALSE,
  flop = FALSE,
  col = "#ff0000"
)
}
\arguments{
\item{x}{object of class "volume", "struct" or "mesh". See \link[espadon]{espadon.class}}

\item{...}{others parameters of plot functions. See details}

\item{view.type}{character string among the values 'ij', 'ji', 'ik', 'ki',
'jk', 'kj', 'yx', 'xz', 'zx', 'yz', 'zy', 'trans', 'front' or 'sagi"
representing the map to be displayed.}

\item{view.coord}{value representing the coordinate where the map is displayed.
This parameter can be a 3D-vector, representing the coordinate of the point on
the displayed map. If \code{NULL}, the display is located in the center of the object.}

\item{flip}{Boolean defaults to \code{FALSE} flipping the horizontal axis
of the background image.}

\item{flop}{Boolean defaults to \code{FALSE} flipping the vertical axis
of the background image.}

\item{cut.interpolate}{Boolean, indicating whether to calculate the volume cut
using linear interpolation.}

\item{display.interpolate}{Boolean, indicating whether to apply linear
interpolation when displaying the cut.}

\item{col}{Vector, representing the color palette of the image, if \code{x}
is of class 'volume'. Color of the mesh outline if object \code{x} is of class 'mesh'.}

\item{breaks}{One of :
\itemize{
\item \code{NULL} : the minimum and the maximum value of the object \code{x} define
the range.
\item Vector giving the breakpoints of each color. Outside values are transparent,
leaving the background visible, depending on \code{sat.transp}.
}}

\item{sat.transp}{Boolean. If \code{TRUE}, outside values are transparent, else
set to \code{breaks} limits colors.}

\item{roi.name}{Vector of exact names of the RoI in the \code{struct} object.
By default \code{roi.name = NULL}. See Details.}

\item{roi.sname}{Vector of names or parts of names of the RoI in the \code{struct}
object. By default \code{roi.sname = NULL}. See Details.}

\item{roi.idx}{Vector of indices of the RoI that belong to the \code{struct}
object. By default \code{roi.idx = NULL}. See Details.}

\item{back.dxyz}{3D vector of voxel size, used to calculate contours in frontal
or sagittal view.}
}
\value{
Returns a display of the  \mjeqn{k^{th}}{ascii} image plane of \code{x}.
}
\description{
The \code{plot} function displays the requested map
of espadon objects of class "volume", "struct", "mesh".
}
\details{
... can be xlim, ylim, add, bg etc. If \code{view.type} is egal to
'trans' or 'front' or 'sagi', the direction of xlim and ylim is ignored.

If \code{roi.name}, \code{roi.sname}, and \code{roi.idx} are
all set to \code{NULL}, all closed planar or point RoI, present at \code{view.coord}
are selected.
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for
# better result)
step <- 5
patient <- toy.load.patient (modality = c("ct","mr", "rtdose", "rtstruct"),
                             dxyz = rep (step, 3), beam.nb = 3)
MR <- patient$mr[[1]]
CT <- patient$ct[[1]]
D <- patient$rtdose[[1]]
S <- patient$rtstruct[[1]]

# display 1
layout (matrix(c(1,1,2,3), ncol=2), widths=c(1,0.2))
plot (CT, view.coord = 0, col = pal.RVV(255))
S_plot <- plot (S, view.coord = 0, add = TRUE, lwd = 2)
display.palette (col = pal.RVV(255), main="HU")
display.legend (S_plot, bg="white", text.col="black", lwd = 2, cex = 1.1)
# display 2
layout (matrix(c (1, 1, 2, 3), ncol = 2), widths = c (1, 0.2))
# Coordinates of the PTV barycenter in CT frame of reference
G <- as.numeric (S$roi.info[S$roi.info$roi.pseudo == "ptv", 
                            c ("Gx", "Gy", "Gz")])
# Coordinates of the PTV baricenter in MR frame of reference
G_MR <- as.numeric (c(G, 1) \%*\% 
                   t(get.rigid.M(CT$ref.pseudo, MR$ref.pseudo, 
                               T.MAT = patient$T.MAT)))[1:3]
plot (MR, view.type = "sagi", view.coord =  G_MR,
      col = grey.colors (255, start = 0, end = 1),
      breaks = seq (0, 500, length.out = 256) , bg = "darkblue")
plot (vol.in.new.ref(D, MR$ref.pseudo, T.MAT = patient$T.MAT),
      view.type = "sagi", view.coord = G_MR,
      col = pal.rainbow(255), add = TRUE)
display.palette (col = grey.colors (255, start = 0, end = 1),
                 breaks = seq (0, 500, length.out = 256), main="MR")
display.palette (col =  pal.rainbow(255),
                 breaks = seq (D$min.pixel, D$max.pixel, length.out = 256),
                 main="Gy")
layout(1)
}
\seealso{
\link[espadon]{display.plane}, \link[espadon]{display.kplane},
\link[espadon]{display.palette}, \link[espadon]{pal.RVV}, \link[espadon]{pal.rainbow}.
}
