% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regresion.simple.R
\name{regresion.simple}
\alias{regresion.simple}
\title{Regresión lineal simple.}
\usage{
regresion.simple(x,
                 var_depen = NULL,
                 var_indepen = NULL,
                 introducir = FALSE,
                 inferencia = FALSE,
                 confianza = 0.95,
                 grafico = FALSE,
                 exportar = FALSE)
}
\arguments{
\item{x}{Conjunto de datos. Es un dataframe con al menos 2 variables (2 columnas).}

\item{var_depen}{Es un vector (numérico o carácter) que indica la variable dependiente.}

\item{var_indepen}{Es un vector (numérico o carácter) que indica la variable independiente.}

\item{introducir}{Valor lógico. Si \code{introducir = FALSE} (por defecto), el usuario debe indicar el conjunto de datos que desea analizar usando los argumentos \code{x} y/o \code{variable}. Si \code{introducir = TRUE}, se le solicitará al ususario que introduzca la información relevante de las variables: vector de medias y matriz de varianzas-covarianzas.}

\item{inferencia}{Si \code{inferencia = FALSE}, valor por defecto, se obtienen los resultados de la regresión simple que se estudian en un curso básico de estadística descriptiva (ver referencias de la función). Si \code{inferencia = TRUE}, se obtienen los resultas inferenciales de la regresión.}

\item{confianza}{Es un valor numérico entre 0 y 1. Indica el nivel de confianza. Por defecto, \code{confianza = 0.95} (95 por ciento)}

\item{grafico}{Si \code{grafico = TRUE}, se muestran algunos de los principales resultados gráficos de la regresión lineal.}

\item{exportar}{Para exportar los resultados a una hoja de cálculo Excel (\code{exportar = TRUE}).}
}
\value{
Si \code{inferencia = FALSE}, la función devuelve los principales resultados de la regresión lineal simple que se estudian en estadística descriptiva en un objeto de la clase \code{data.frame}.
Si \code{inferencia = TRUE}, la función devuelve los resultados de inferenciales de la regresión. Estos contenidos son estudiados en cursos de inferencia estadística y en temas introductorios de econometría.
}
\description{
Calcula la regresión lineal simple.

Lee el código QR para video-tutorial sobre el uso de la función con un ejemplo.

\if{html}{\figure{qrregresion1.png}{options: width="25\%" alt="Figure: qrmuestra1.png"}}
\if{latex}{\figure{qrregresion1.png}{options: width=3cm}}

\if{html}{\figure{qrregresion2.png}{options: width="25\%" alt="Figure: qrmuestra1.png"}}
\if{latex}{\figure{qrregresion2.png}{options: width=3cm}}
}
\details{
Se obtiene la recta de regresión minimocuadrática de Y (variable dependiente) en función de X (variable independiente).
La recta de regresión puede expresarse como:

\if{html}{\figure{regresion1.png}{options: width="50\%" alt="Figure: regresion1.png"}}
\if{latex}{\figure{regresion1.png}{options: width=7cm}}

o alternativamente:

\if{html}{\figure{regresion2.png}{options: width="75\%" alt="Figure: regresion2"}}
\if{latex}{\figure{regresion2.png}{options: width=10cm}}

En las representaciones gráficas las observaciones anómals se detectan a partir del punto leverage:

\if{html}{\figure{influyente.png}{options: width="50\%" alt="Figure: influyente.png"}}
\if{latex}{\figure{influyente.png}{options: width=6cm}}

de forma que una observación tendrá efecto de apalancamiento si:

\if{html}{\figure{obsinfluyente.png}{options: width="25\%" alt="Figure: obsinfluyente.png"}}
\if{latex}{\figure{obsinfluyente.png}{options: width=2.5cm}}

 donde p=2 (en el caso de la regresión simple). En general, p es igual al número de variables independientes más la constante.

Por otra parte, las observaciones atípicas se identifican a partir de los errores estandarizados (se). Estos errores se obtienen a partir de:

\if{html}{\figure{errorstandarizado.png}{options: width="45\%" alt="Figure: errorstandarizado.png"}}
\if{latex}{\figure{errorstandarizado.png}{options: width=6cm}}

Una observación será atípica si:

\if{html}{\figure{obsatipica.png}{options: width="20\%" alt="Figure: obsatipica.png"}}
\if{latex}{\figure{obsatipica.png}{options: width=2cm}}

 @seealso \code{\link{matriz.covar}}, \code{\link{matriz.correlacion}}
}
\examples{

## Not run:
ejemplo_regresion <- regresion.simple(turistas,
var_depen=2,var_indepen=3,grafico=TRUE)
## End(Not run)

}
\references{
Esteban García, J. y otros. (2005). Estadística descriptiva y nociones de probabilidad. Paraninfo. ISBN: 9788497323741

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
