% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prices_from_tickers.R
\name{get_prices_from_tickers}
\alias{get_prices_from_tickers}
\title{Get daily prices of securities.}
\usage{
get_prices_from_tickers(..., start, end, quote = c("Open", "Close"),
  retclass = c("list", "zoo", "data.frame"))
}
\arguments{
\item{...}{character vectors indicating tickers (should be valid in Yahoo
Finance).}

\item{start}{an object of \code{Date} class specifying the first date of the
observed time period.}

\item{end}{an object of \code{Date} class specifying the last date of the
observed time period.}

\item{quote}{a character indicating the type of the price: \code{"Open"}
(default) or \code{"Close"}.}

\item{retclass}{a character specifying the return class: \code{"list"}
(default), \code{"zoo"} or \code{"data.frame"}.}
}
\value{
Prices of securities as \code{"list"}, \code{"zoo"}, or
\code{"data.frame"}.
}
\description{
Returns daily Open or Close prices between \code{start} and \code{end}
date for given tickers.
}
\details{
This function uses the function \code{getSymbols} form the \code{quantmod}
package. The provider is set automatically to Yahoo Finance. The function
returns the data in different class-containers: list of \code{zoo}'s,
\code{zoo}, or \code{data.frame}.
}
\examples{
## Download historical prices of nine European insurance companies'
## stocks:
\dontrun{
library("magrittr")
tickers <- c("ALV.DE", "CS.PA", "G.MI", "HNR1.HA", "HSX.L", "MUV2.DE",
             "RSA.L", "TOP.CO")
prices <- tickers \%>\%
    get_prices_from_tickers(start = as.Date("2000-01-01"),
                            end = as.Date("2002-01-01"),
                            quote = "Close",
                            retclass = "zoo")
}
## The result of the above code is stored in:
data(prices)

## Download historical prices of ESTX50 EUR P index:
\dontrun{
prices_indx <- get_prices_from_tickers("^STOXX50E",
                                       start = as.Date("2000-01-01"),
                                       end = as.Date("2002-01-01"),
                                       quote = "Close",
                                       retclass = "zoo")
}
## The result of the above code is stored in:
data(prices_indx)

}
\seealso{
\code{\link[quantmod]{getSymbols}}
}
