% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Viz2VarsVsLTime.R
\name{Viz2VarsVsLTime}
\alias{Viz2VarsVsLTime}
\title{Plot two scores with confidence intervals in a common plot}
\usage{
Viz2VarsVsLTime(
  var1,
  var2,
  toptitle = "",
  ytitle = "",
  monini = 1,
  freq = 12,
  nticks = NULL,
  limits = NULL,
  listexp = c("exp1", "exp2", "exp3"),
  listvars = c("var1", "var2"),
  biglab = FALSE,
  hlines = NULL,
  drawleg = TRUE,
  leg = NULL,
  siglev = FALSE,
  title_scale = 1,
  sizetit = NULL,
  show_conf = TRUE,
  fileout = NULL,
  width = 8,
  height = 5,
  size_units = "in",
  res = 100,
  ...
)
}
\arguments{
\item{var1}{Matrix of dimensions (nexp/nmod, nltime).}

\item{var2}{Matrix of dimensions (nexp/nmod, nltime).}

\item{toptitle}{Main title, optional.}

\item{ytitle}{Title of Y-axis, optional.}

\item{monini}{Starting month between 1 and 12. Default = 1.}

\item{freq}{1 = yearly, 12 = monthly, 4 = seasonal, ... Default = 12.}

\item{nticks}{Number of ticks and labels on the x-axis, optional.}

\item{limits}{c(lower limit, upper limit): limits of the Y-axis, optional.}

\item{listexp}{List of experiment names, up to three, optional.}

\item{listvars}{List of names of input variables, optional.}

\item{biglab}{TRUE/FALSE for presentation/paper plot. Default = FALSE.}

\item{hlines}{c(a, b, ...) Add horizontal black lines at Y-positions a, b, 
... The default value is NULL.}

\item{drawleg}{TRUE/FALSE if legend should be added or not to the plot. 
Default = TRUE.}

\item{leg}{Deprecated. Use 'drawleg' instead.}

\item{siglev}{TRUE/FALSE if significance level should replace confidence 
interval.\cr 
Default = FALSE.}

\item{title_scale}{Multiplicative factor to change title size, optional.}

\item{sizetit}{Deprecated. Use 'title_scale' instead.}

\item{show_conf}{TRUE/FALSE to show/not confidence intervals for input 
variables.}

\item{fileout}{Name of output file. Extensions allowed: eps/ps, jpeg, png, 
pdf, bmp and tiff. The default value is NULL.}

\item{width}{File width, in the units specified in the parameter size_units 
(inches by default). Takes 8 by default.}

\item{height}{File height, in the units specified in the parameter 
size_units (inches by default). Takes 5 by default.}

\item{size_units}{Units of the size of the device (file or window) to plot 
in. Inches ('in') by default. See ?Devices and the creator function of the 
corresponding device.}

\item{res}{Resolution of the device (file or window) to plot in. See 
?Devices and the creator function of the corresponding device.}

\item{...}{Arguments to be passed to the method. Only accepts the following
graphical parameters:\cr  
adj ann ask bg bty cex.sub cin col.axis col.lab col.main col.sub cra crt 
csi cxy err family fg fig font font.axis font.lab font.main font.sub lend 
lheight ljoin lmitre mar mex mfcol mfrow mfg mkh oma omd omi page pch plt 
smo srt tck tcl usr xaxp xaxs xaxt xlog xpd yaxp yaxs yaxt ylbias ylog \cr
For more information about the parameters see `par`.}
}
\value{
A figure in popup window by default, or saved to the specified path
via \code{fileout}.
}
\description{
Plot two input variables that have the same dimensions in a common plot.
One plot for all experiments.
The input variables should have dimensions (nexp/nmod, nltime).
}
\examples{
clim <- s2dv::Clim(ts_temp$exp, ts_temp$obs, time_dim = "sdate", 
                   dat_dim = c("dat", "member"))
ano_exp <- s2dv::Ano(ts_temp$exp, clim$clim_exp)
ano_obs <- s2dv::Ano(ts_temp$obs, clim$clim_obs)
corr_ano <- s2dv::Corr(s2dv::MeanDims(ano_exp, 'member'), ano_obs,
                       time_dim = 'sdate', dat_dim = 'dat')
input_cor <- array(dim = c(dat = 1, 3, time = 5))
input_cor[, 1, ] <- corr_ano$conf.lower[, 1, 1, ]
input_cor[, 2, ] <- corr_ano$corr[, 1, 1, ]
input_cor[, 3, ] <- corr_ano$conf.upper[, 1, 1, ]

rms_ano <- s2dv::RMS(s2dv::MeanDims(ano_exp, 'member'), ano_obs,
                     time_dim = 'sdate', dat_dim = 'dat')

input_rms <- array(dim = c(dat = 1, 3, time = 5))
input_rms[, 1, ] <- rms_ano$conf.lower[, 1, 1, ]
input_rms[, 2, ] <- rms_ano$rms[, 1, 1, ]
input_rms[, 3, ] <- rms_ano$conf.upper[, 1, 1, ]
Viz2VarsVsLTime(input_cor, input_rms,
                toptitle = "Time correlation and RMSE with ERA5",
                ytitle = "K", title_scale = 0.7,
                monini = 11, freq = 1, limits = c(-1, 5),
                listexp = c('SEAS5'), listvars = c('Corr', 'RMSE'),
                fileout = NULL)

}
