% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{match_files_by_year_months}
\alias{extract_date_from_filename}
\alias{match_files_by_year_months}
\title{Match year and month vectors to filenames}
\usage{
match_files_by_year_months(files, pattern,
  years = as.numeric(format(Sys.Date(), "\%Y")), months = 1:12, ...)

extract_date_from_filename(files, pattern, ...)
}
\arguments{
\item{files}{a character vector of filenames}

\item{pattern}{a regular expression to be passed to \code{\link[lubridate]{fast_strptime}}}

\item{years}{a numeric vector of years}

\item{months}{a numberic vector of months}

\item{...}{arguments passed to \code{\link[lubridate]{fast_strptime}}}
}
\value{
a character vector of \code{files} that match the \code{pattern}, \code{year}, and \code{month} arguments

a vector of \code{\link{POSIXct}} dates matching the pattern
}
\description{
Match year and month vectors to filenames

Extracts a date from filenames
}
\examples{
\dontrun{
if (require(airlines)) {
  airlines <- etl("airlines", dir = "~/dumps/airlines") \%>\%
    etl_extract(year = 1987)
  summary(airlines)
  match_files_by_year_months(list.files(attr(airlines, "raw_dir")),
    pattern = "On_Time_On_Time_Performance_\%Y_\%m.zip"), year = 1987)
}
}
}

