% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roles.R
\name{roles}
\alias{role_add}
\alias{role_delete}
\alias{role_get}
\alias{role_list}
\alias{roles}
\title{etcd authentication - roles}
\arguments{
\item{role}{(character) Role to act upon}

\item{perm_read}{Read permission to set}

\item{perm_write}{Write permission to set}

\item{grant_read}{Grant read permission to set}

\item{grant_write}{Grant write permission to set}

\item{revoke_read}{Revoke read permission to set}

\item{revoke_write}{Revoke write permission to set}

\item{auth_user, auth_pwd}{(character) Username and password for the authenticated user,
the root user}

\item{...}{Further args passed on to \code{\link[httr]{GET}},
\code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}
}
\value{
see return for each method
}
\description{
etcd authentication - roles
}
\section{Methods}{

\itemize{
 \item role_list: list roles, a list of roles
 \item role_add: add a role, returns a list on success
 \item role_get: get a role by name, a list of details for the role
 \item role_delete: delete a role by name, nothing returned on success
}
}
\examples{
\dontrun{
# make a client
cli <- etcd()

# Add role
#perms <- list(fun = list(kv = list(read = "/message/*")))
#cli$role_add(role = "fun", perm_read = perms, auth_user="root",
#  auth_pwd="pickbetterpwd")

# List roles
cli$role_list()

# Get a single role
cli$role_get("root")
cli$role_get("fun")

# Delete role
cli$role_delete("fun", "root", "pickbetterpwd")

# Update a role
### FIXME - still working on this
## First, create
# cli$role_add("stuff", perm_read = "/message/*", perm_write = "/message/*",
#    auth_user = "root", auth_pwd = "pickbetterpwd")
## udpate
# "xxx"
## get
# cli$role_get("stuff")
}
}

