set.seed(123)
data("mpdta", package = "did")
mpdta$xvar = rep(sample(1:3, size = 500, replace = TRUE), each = 5) # a categorical var for every id
mpdta$emp = exp(mpdta$lemp)

# Known outputs ----

# from etwfe(...) |> fixest::coeftable() |> dput()

x1_known = structure(c(
  -0.019524066522547, -0.0796380318073288, -0.134204917778194,
  -0.10841966070768, 0.0152968423715633, -0.0336946809186372, -0.0511485418564485,
  -0.146970466674907, -0.145527532198954, -0.119389584067427, -0.160589500183802,
  0.392650575261013, 0.36783545945102, 0.356553696150746, 0.416040724307114,
  -0.315929689723959, -0.259362390202098, 0.0945272527844957, 0.0413076670240288,
  0.049819476896445, 0.0521473059039472, 0.0503694583788559, 0.0492482867693856,
  0.0526698491592972, 0.0206064514873498, 0.084973991690449, 0.0859359599154286,
  0.0927862096242763, 0.110463442441824, 0.474414786422139, 0.491983949605475,
  0.496886146535474, 0.492973837789661, 0.211752705381633, 0.224124116369785,
  0.202875296656991, -0.472649944408378, -1.59853207557488, -2.57357336974211,
  -2.15248811873649, 0.310606589081843, -0.639733765265387, -2.48216156419986,
  -1.72959353504663, -1.69344163191021, -1.28671690061354, -1.45377960919856,
  0.827652481538864, 0.747657438308687, 0.717576246866224, 0.843940778221638,
  -1.49197475023789, -1.15722660462908, 0.465937718106292, 0.636669598343082,
  0.110557582895499, 0.010352989882257, 0.0318377451602625, 0.756229412191112,
  0.522639292547323, 0.0133867055285317, 0.0843213094558584, 0.0909955227125064,
  0.198789580958878, 0.146636049203268, 0.408262971306305, 0.455018992936602,
  0.473354388218296, 0.399106892734559, 0.136337680903557, 0.24773343305709,
  0.641463392419704
), dim = c(18L, 4L), dimnames = list(c(
  ".Dtreat:first.treat::2004:year::2004",
  ".Dtreat:first.treat::2004:year::2005", ".Dtreat:first.treat::2004:year::2006",
  ".Dtreat:first.treat::2004:year::2007", ".Dtreat:first.treat::2006:year::2006",
  ".Dtreat:first.treat::2006:year::2007", ".Dtreat:first.treat::2007:year::2007",
  "xvar_dm:year::2004", "xvar_dm:year::2005", "xvar_dm:year::2006",
  "xvar_dm:year::2007", ".Dtreat:first.treat::2004:year::2004:xvar_dm",
  ".Dtreat:first.treat::2004:year::2005:xvar_dm", ".Dtreat:first.treat::2004:year::2006:xvar_dm",
  ".Dtreat:first.treat::2004:year::2007:xvar_dm", ".Dtreat:first.treat::2006:year::2006:xvar_dm",
  ".Dtreat:first.treat::2006:year::2007:xvar_dm", ".Dtreat:first.treat::2007:year::2007:xvar_dm"
), c("Estimate", "Std. Error", "t value", "Pr(>|t|)")), type = "Clustered (countyreal)")

x2_known = structure(c(
  -0.0177280343359208, -0.0780488449553613, -0.144502200465749,
  -0.109497312646439, 0.00289701082107226, 0.00211334616529051,
  -0.00203395773586354, -0.0418058502772696, 0.00926716038018843,
  0.00743701021305051, -0.0241148800169485, -0.0526204972477396,
  -0.146540424243215, -0.140221010410396, -0.14334560069108, -0.160589500183802,
  0.392220532829321, 0.362528937662463, 0.380509712774398, 0.416040724307114,
  -0.244514638501927, -0.274903207329148, -0.291973673100306, -0.259362390202098,
  0.0833293637759091, 0.0756944866486444, 0.0750904084843893, 0.0945272527844958,
  0.0440720383040453, 0.0522729383191798, 0.0548353266673802, 0.0516401960235384,
  0.0636099817026747, 0.0678731393998407, 0.0696193321095047, 0.0709176754417547,
  0.0228546240143982, 0.0265618724170887, 0.0302942605296121, 0.0316047304792741,
  0.10963206522597, 0.111567402209322, 0.111080071103372, 0.110687370185209,
  0.480366658608915, 0.498059102569706, 0.501589888459173, 0.493973177631002,
  0.211505909019859, 0.221153699092346, 0.220769084315501, 0.224578453175766,
  0.202163692441356, 0.201968369885714, 0.203900057675943, 0.203286558576452,
  -0.402251291706053, -1.49310231000969, -2.63520269227663, -2.12038917506294,
  0.0455433368085758, 0.031136708629916, -0.0292154158081309, -0.589498316419087,
  0.405482950598978, 0.279988176144761, -0.796021411163894, -1.66495636728329,
  -1.33665660626907, -1.25682777974264, -1.29047091226366, -1.45083851856896,
  0.816502406651505, 0.727883369246774, 0.758607223808439, 0.842233431180136,
  -1.15606528269131, -1.24304141625214, -1.32252971019732, -1.15488546000051,
  0.412187583089785, 0.374783866857355, 0.368270658381715, 0.464995095821576,
  0.68767134403285, 0.136042397716835, 0.00867026326544244, 0.0344659964417245,
  0.963692452779878, 0.975172964142093, 0.976704467111947, 0.555793841291965,
  0.685296341587234, 0.779602602973807, 0.426398107590619, 0.0965491554160323,
  0.181943857377524, 0.209403992471146, 0.19748482867384, 0.147453145193911,
  0.414602462031274, 0.467026383425208, 0.448445704376072, 0.400060781296184,
  0.248207649265377, 0.214436312698668, 0.186597635455983, 0.248690072063308,
  0.680378950161645, 0.707980441184006, 0.712827602846716, 0.642137810522659
), dim = c(28L, 4L), dimnames = list(c(
  ".Dtreat:first.treat::2004:year::2004",
  ".Dtreat:first.treat::2004:year::2005", ".Dtreat:first.treat::2004:year::2006",
  ".Dtreat:first.treat::2004:year::2007", ".Dtreat:first.treat::2006:year::2004",
  ".Dtreat:first.treat::2006:year::2005", ".Dtreat:first.treat::2006:year::2006",
  ".Dtreat:first.treat::2006:year::2007", ".Dtreat:first.treat::2007:year::2004",
  ".Dtreat:first.treat::2007:year::2005", ".Dtreat:first.treat::2007:year::2006",
  ".Dtreat:first.treat::2007:year::2007", "xvar_dm:year::2004",
  "xvar_dm:year::2005", "xvar_dm:year::2006", "xvar_dm:year::2007",
  ".Dtreat:first.treat::2004:year::2004:xvar_dm", ".Dtreat:first.treat::2004:year::2005:xvar_dm",
  ".Dtreat:first.treat::2004:year::2006:xvar_dm", ".Dtreat:first.treat::2004:year::2007:xvar_dm",
  ".Dtreat:first.treat::2006:year::2004:xvar_dm", ".Dtreat:first.treat::2006:year::2005:xvar_dm",
  ".Dtreat:first.treat::2006:year::2006:xvar_dm", ".Dtreat:first.treat::2006:year::2007:xvar_dm",
  ".Dtreat:first.treat::2007:year::2004:xvar_dm", ".Dtreat:first.treat::2007:year::2005:xvar_dm",
  ".Dtreat:first.treat::2007:year::2006:xvar_dm", ".Dtreat:first.treat::2007:year::2007:xvar_dm"
), c("Estimate", "Std. Error", "t value", "Pr(>|t|)")), type = "Clustered (countyreal)")

x3_known = structure(c(
  -0.0127020076747978, -0.0752671139311374, -0.128226490551655,
  -0.0995567882709647, 0.0168748779423594, -0.0364935045756735,
  -0.0438524359835098, 0.010569479215233, 0.0136058916590233, 0.0176258547231566,
  0.00676683200634787, 0.0327034046338209, 0.0551405431042205,
  0.0843411361833482, 0.0427341686646161, 0.0351948615638335, 0.0339917114173117,
  -0.0138851572782492, -0.0389152141236949, -0.0746826408392234,
  -0.0638394176825093, -0.0266215204150605, -0.0844569377184431,
  -0.0557748584645892, 0.000150834991439431, -0.0572949220312891,
  -0.0548744604238468, -0.0663962243145746, -0.0661239026367919,
  0.0403705207604732, 0.0246184900087866, 0.0604147687768023, 0.028612988379879,
  0.0321856708638562, 0.0335923373410169, 0.0357580830961519, 0.028595128212853,
  0.0347953037066878, 0.0188306443850416, 0.0310909408265633, 0.0308188232644652,
  0.0344470566473297, 0.0395057946426871, 0.039641138824891, 0.0428137291620237,
  0.0478644203444771, 0.0445637612257664, 0.0287809614466705, 0.0349548465352499,
  0.0185491325864473, 0.080991011788536, 0.0862428301967164, 0.0935887860083309,
  0.0824948268636148, 0.0743339735084916, 0.0785210207685315, 0.0741807312497328,
  0.0481776819753547, 0.0560697381815008, 0.0622811913916597, 0.0467733382722524,
  0.0669472481335961, 0.0741304105793119, 0.0461305754805009, -0.443924538959727,
  -2.33852866542734, -3.81713511774867, -2.78417576253349, 0.590131221540544,
  -1.04880546188937, -2.3287804223176, 0.339953662843253, 0.441479920964769,
  0.511679558100154, 0.171287074910173, 0.824986506525038, 1.28791731492362,
  1.76208414468097, 0.958944386406675, 1.22285218404005, 0.972446306781325,
  -0.74856100216752, -0.480488059901027, -0.865957676352635, -0.68212678468579,
  -0.322705331075763, -1.13618220219043, -0.710317541961219, 0.00203334462869661,
  -1.18924198263831, -0.978682301783096, -1.06607184016499, -1.41370928565984,
  0.603019868418073, 0.332097041098233, 1.30964697811627, 0.657289578444948,
  0.0197537724714263, 0.000151981494891809, 0.00557017669702286,
  0.55536981325649, 0.294775363724548, 0.0202691604222472, 0.734034471150892,
  0.659056831833994, 0.609101647208813, 0.864067478310184, 0.409773447723853,
  0.198371676791521, 0.0786673137318954, 0.338051153099976, 0.221962748259508,
  0.331299705488395, 0.454474520646414, 0.631090967325786, 0.386929526737329,
  0.495475282817589, 0.747053583524952, 0.256425680674488, 0.477839069873686,
  0.998378439442247, 0.234910040302946, 0.328211212193456, 0.286906698953214,
  0.158070816954004, 0.546769438464448, 0.739955432429093, 0.190917928915292
), dim = c(32L, 4L), dimnames = list(c(
  ".Dtreat:first.treat::2004:year::2004",
  ".Dtreat:first.treat::2004:year::2005", ".Dtreat:first.treat::2004:year::2006",
  ".Dtreat:first.treat::2004:year::2007", ".Dtreat:first.treat::2006:year::2006",
  ".Dtreat:first.treat::2006:year::2007", ".Dtreat:first.treat::2007:year::2007",
  "xvar_dm:year::2004", "xvar_dm:year::2005", "xvar_dm:year::2006",
  "xvar_dm:year::2007", ".Dtreat:first.treat::2004:year::2004:lpop_dm",
  ".Dtreat:first.treat::2004:year::2005:lpop_dm", ".Dtreat:first.treat::2004:year::2006:lpop_dm",
  ".Dtreat:first.treat::2004:year::2007:lpop_dm", ".Dtreat:first.treat::2006:year::2006:lpop_dm",
  ".Dtreat:first.treat::2006:year::2007:lpop_dm", ".Dtreat:first.treat::2007:year::2007:lpop_dm",
  ".Dtreat:first.treat::2004:year::2004:xvar_dm", ".Dtreat:first.treat::2004:year::2005:xvar_dm",
  ".Dtreat:first.treat::2004:year::2006:xvar_dm", ".Dtreat:first.treat::2004:year::2007:xvar_dm",
  ".Dtreat:first.treat::2006:year::2006:xvar_dm", ".Dtreat:first.treat::2006:year::2007:xvar_dm",
  ".Dtreat:first.treat::2007:year::2007:xvar_dm", ".Dtreat:first.treat::2004:year::2004:xvar_dm:lpop_dm",
  ".Dtreat:first.treat::2004:year::2005:xvar_dm:lpop_dm", ".Dtreat:first.treat::2004:year::2006:xvar_dm:lpop_dm",
  ".Dtreat:first.treat::2004:year::2007:xvar_dm:lpop_dm", ".Dtreat:first.treat::2006:year::2006:xvar_dm:lpop_dm",
  ".Dtreat:first.treat::2006:year::2007:xvar_dm:lpop_dm", ".Dtreat:first.treat::2007:year::2007:xvar_dm:lpop_dm"
), c("Estimate", "Std. Error", "t value", "Pr(>|t|)")), type = "Clustered (countyreal)")

x3p_known = structure(c(
  -0.0346004088213415, -0.0803179736233184, -0.146037347254729,
  -0.12858363211337, -0.014520383567862, -0.0723619322066703, -0.0534477540132797,
  0.0444170298612762, 0.0327116212235207, 0.0400911444564683, 0.0136924085319922,
  0.0137390198712382, 0.0338190520058627, 0.0485349984147131, 0.0379881314903882,
  0.0699754466129776, 0.0622605826442866, 0.000934697613207469,
  -0.082673684757087, -0.0864348391945273, -0.107039926930645,
  -0.0410719797566676, -0.13425610444774, -0.0745310900581121,
  0.0233966626088736, 0.00860066329529083, 0.00705018233233272,
  0.0164612724394597, -0.00190944414427435, 0.0890119504471164,
  0.0520053159359483, 0.0157403334946735, 0.0302437394950895, 0.0368496668151395,
  0.0347664481389924, 0.0357748260306487, 0.032181451801508, 0.0300515464960223,
  0.024933720718255, 0.0338510140680331, 0.0321324362508995, 0.0367646250098998,
  0.0459114100049168, 0.0239341328602869, 0.0272644922816977, 0.0285024657782588,
  0.0241114135035524, 0.0311987876817399, 0.0390290123297341, 0.0171391337275025,
  0.11063887332931, 0.114182546766712, 0.114718037153431, 0.121561459037233,
  0.0828308271680494, 0.0874743092542879, 0.0732425266292059, 0.054170974931896,
  0.0568485366224404, 0.0569733762920858, 0.0568245282394013, 0.0289773524285773,
  0.029711717432717, 0.0250343522235045, -1.14405193930993, -2.17961193587564,
  -4.20052536488307, -3.59424898399816, -0.451203496269289, -2.40792706679,
  -2.14359319321919, 1.31213291785019, 1.01802493181963, 1.09048152798166,
  0.298235417525314, 0.574034578626197, 1.24040644720037, 1.70283507371965,
  1.57552486438803, 2.24288992658304, 1.59523848869867, 0.0545358725865823,
  -0.747239033346024, -0.756988188143357, -0.933069721089135, -0.337870078904595,
  -1.62084708118824, -0.852034050837146, 0.319440954396896, 0.158768848190449,
  0.124016953666838, 0.288929207127688, -0.0336024636443944, 3.0717765077576,
  1.75033018719688, 0.628749382214694, 0.252602097533795, 0.0292862392938574,
  2.6629633077478e-05, 0.000325328619280014, 0.651842890019017,
  0.0160433856903933, 0.0320654966573325, 0.189475290959657, 0.308666107842652,
  0.275501085913858, 0.765523491760668, 0.565944402199233, 0.214825097550641,
  0.0885989371175102, 0.115135343817303, 0.0249039135130414, 0.110658914911768,
  0.956508228912189, 0.454919286307399, 0.44905693904927, 0.350783971392564,
  0.735461096525987, 0.105050438393239, 0.394195193285995, 0.749392159138651,
  0.873850992990507, 0.901301851605938, 0.772635552401631, 0.973194157675069,
  0.00212788980200811, 0.0800613548543431, 0.52951314308095
), dim = c(
  32L,
  4L
), dimnames = list(c(
  ".Dtreat:first.treat::2004:year::2004",
  ".Dtreat:first.treat::2004:year::2005", ".Dtreat:first.treat::2004:year::2006",
  ".Dtreat:first.treat::2004:year::2007", ".Dtreat:first.treat::2006:year::2006",
  ".Dtreat:first.treat::2006:year::2007", ".Dtreat:first.treat::2007:year::2007",
  "xvar_dm:year::2004", "xvar_dm:year::2005", "xvar_dm:year::2006",
  "xvar_dm:year::2007", ".Dtreat:first.treat::2004:year::2004:lpop_dm",
  ".Dtreat:first.treat::2004:year::2005:lpop_dm", ".Dtreat:first.treat::2004:year::2006:lpop_dm",
  ".Dtreat:first.treat::2004:year::2007:lpop_dm", ".Dtreat:first.treat::2006:year::2006:lpop_dm",
  ".Dtreat:first.treat::2006:year::2007:lpop_dm", ".Dtreat:first.treat::2007:year::2007:lpop_dm",
  ".Dtreat:first.treat::2004:year::2004:xvar_dm", ".Dtreat:first.treat::2004:year::2005:xvar_dm",
  ".Dtreat:first.treat::2004:year::2006:xvar_dm", ".Dtreat:first.treat::2004:year::2007:xvar_dm",
  ".Dtreat:first.treat::2006:year::2006:xvar_dm", ".Dtreat:first.treat::2006:year::2007:xvar_dm",
  ".Dtreat:first.treat::2007:year::2007:xvar_dm", ".Dtreat:first.treat::2004:year::2004:xvar_dm:lpop_dm",
  ".Dtreat:first.treat::2004:year::2005:xvar_dm:lpop_dm", ".Dtreat:first.treat::2004:year::2006:xvar_dm:lpop_dm",
  ".Dtreat:first.treat::2004:year::2007:xvar_dm:lpop_dm", ".Dtreat:first.treat::2006:year::2006:xvar_dm:lpop_dm",
  ".Dtreat:first.treat::2006:year::2007:xvar_dm:lpop_dm", ".Dtreat:first.treat::2007:year::2007:xvar_dm:lpop_dm"
), c("Estimate", "Std. Error", "t value", "Pr(>|t|)")), type = "Clustered (countyreal)")


# Tests ----

# No other controls
x1 = etwfe(lemp ~ 0, tvar = year, gvar = first.treat, xvar = xvar, data = mpdta, vcov = ~countyreal)
x1a = etwfe(lemp ~ 0, tvar = "year", gvar = "first.treat", xvar = "xvar", data = mpdta, vcov = ~countyreal) # chars instead of nse
x1r = etwfe(lemp ~ 0, tvar = "year", gvar = "first.treat", xvar = "xvar", data = mpdta, vcov = ~countyreal, gref = 0) # with explicit ref

expect_equal(fixest::coeftable(x1), x1_known)
expect_equal(fixest::coeftable(x1a), x1_known)
expect_equal(fixest::coeftable(x1r), x1_known)

# With never-treated control group
x2 = etwfe(lemp ~ 0,
  tvar = year, gvar = first.treat, xvar = xvar, data = mpdta, vcov = ~countyreal,
  cgroup = "never"
)

expect_equal(fixest::coeftable(x2), x2_known)

# With controls
x3 = etwfe(lemp ~ lpop, tvar = year, gvar = first.treat, xvar = xvar, data = mpdta, vcov = ~countyreal)
expect_equal(fixest::coeftable(x3), x3_known)

expect_error(
  etwfe(lemp ~ 0, tvar = NULL, gvar = first.treat, data = mpdta)
)

# Poisson version
x3p = etwfe(emp ~ lpop, tvar = year, gvar = first.treat, xvar = xvar, data = mpdta, vcov = ~countyreal, family = "poisson")
expect_equal(fixest::coeftable(x3p), x3p_known)
