% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.euler.R
\name{panel.euler}
\alias{panel.euler}
\title{Panel Function for Euler Diagrams}
\usage{
panel.euler(x, y, r, subscripts, fill = superpose.polygon$col,
  lty = superpose.polygon$lty, lwd = superpose.polygon$lwd,
  border = superpose.polygon$border, alpha = superpose.polygon$alpha,
  fontface = "bold", counts = TRUE, labels = NULL, original.values,
  fitted.values, ...)
}
\arguments{
\item{x}{X coordinates for the circle centers.}

\item{y}{Y coordinates for the circle centers.}

\item{r}{Radii.}

\item{subscripts}{A vector of subscripts (See \code{\link[lattice:xyplot]{lattice::xyplot()}}).}

\item{fill}{Fill color for circles. (See \code{\link[grid:gpar]{grid::gpar()}}.)}

\item{lty}{Line type for circles. (See \code{\link[grid:gpar]{grid::gpar()}}.)}

\item{lwd}{Line weight for circles. (See \code{\link[grid:gpar]{grid::gpar()}}.)}

\item{border}{Border color for circles.}

\item{alpha}{Alpha for circles. Note that \code{\link[=plot.euler]{plot.euler()}} by default
modifies the alpha of \code{col} instead to avoid affecting the alpha of
the borders. (See \code{\link[grid:gpar]{grid::gpar()}}.)}

\item{fontface}{Fontface for the labels.  (See \code{\link[grid:gpar]{grid::gpar()}}.)}

\item{counts}{Plots the original values for the disjoint set combinations
(\code{original.values}). Can also be a list, in which the contents of the list
will be passed on to \code{\link[lattice:panel.text]{lattice::panel.text()}} to modify the appearance of
the counts.}

\item{labels}{Labels to plot on the circles.}

\item{original.values}{Original values for the disjoint set combinations.}

\item{fitted.values}{Fitted values for the disjoint set combinations.}

\item{...}{Passed down to \code{\link[=panel.euler.circles]{panel.euler.circles()}} and \code{\link[=panel.euler.labels]{panel.euler.labels()}}.}
}
\value{
Plots euler diagrams inside a trellis panel.
}
\description{
Panel Function for Euler Diagrams
}
\seealso{
\code{\link[grid:gpar]{grid::gpar()}}.
}
