% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eurostat_dic.R
\name{get_eurostat_dic}
\alias{get_eurostat_dic}
\title{Download Eurostat Dictionary}
\usage{
get_eurostat_dic(dictname, lang = "en")
}
\arguments{
\item{dictname}{A character, dictionary for the variable to be downloaded.}

\item{lang}{A character, language code. Options: "en" (default) / "fr" / "de".}
}
\value{
tibble with two columns: code names and full names.
}
\description{
Download a Eurostat dictionary.
}
\details{
For given coded variable from Eurostat \url{https://ec.europa.eu/eurostat/}.
   The dictionaries link codes with human-readable labels.
   To translate codes to labels, use \code{\link{label_eurostat}}.
}
\examples{
\dontrun{
	       tmp <- get_eurostat_dic("crop_pro")
	       head(tmp)
	       tmp <- get_eurostat_dic("crop_pro", lang = "fr")
     }
}
\references{
See citation("eurostat").
}
\seealso{
\code{\link{label_eurostat}}, \code{\link{get_eurostat}}, 
         \code{\link{search_eurostat}}.
}
\author{
Przemyslaw Biecek and Leo Lahti \email{leo.lahti@iki.fi}. Thanks to Wietse Dol for contributions.
}
\keyword{database}
\keyword{utilities}
