% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpdSeqTests.R
\name{gpdSeqTests}
\alias{gpdSeqTests}
\title{GPD Multiple Threshold Goodness-of-Fit Testing}
\usage{
gpdSeqTests(data, thresholds = NA, nextremes = NA, method = c("ad", "cvm",
  "pbscore", "multscore", "imasym", "impb"), nsim = NULL, inner = NULL,
  outer = NULL, information = c("expected", "observed"),
  allowParallel = FALSE, numCores = 1)
}
\arguments{
\item{data}{Original, full dataset in vector form.}

\item{thresholds}{A set of threshold values (either this or a set of the number of extremes must be given, but not both). Must be provided as a vector.}

\item{nextremes}{A set of the number of upper extremes to be used, provided as a vector.}

\item{method}{Which test to run to sequentially test the thresholds. Must be one of 'ad', 'cvm', 'pbscore', 'multscore', 'imasym', or 'impb'.}

\item{nsim}{Number of boostrap replicates for the 'ad', 'cvm', 'pbscore', 'multscore', and 'imasym' tests.}

\item{inner}{Number of inner boostrap replicates if 'impb' test is chosen.}

\item{outer}{Number of outer boostrap replicates if 'impb' test is chosen.}

\item{information}{To use observed or expected (default) information for the 'pbscore' and 'multscore' tests.}

\item{allowParallel}{If selected, should the 'cvm', 'ad', 'pbscore', or 'impb' procedure be run in parallel or not. Defaults to false.}

\item{numCores}{If allowParallel is true, specify the number of cores to use.}
}
\value{
\item{threshold}{The threshold used for the test.}
\item{num.above}{The number of observations above the given threshold.}
\item{p.values}{Raw p-values for the thresholds tested.}
\item{ForwardStop}{Transformed p-values according to the ForwardStop stopping rule.}
\item{StrongStop}{Transformed p-values according to the StrongStop stopping rule.}
\item{statistic}{Returned test statistics of each individual test.}
\item{est.scale}{Estimated scale parameter for the given threshold.}
\item{est.shape}{Estimated shape parameter for the given threshold.}
}
\description{
Wrapper function to test multiple thresholds for goodness-of-fit to the Generalized Pareto model. Can choose which test to
run from the available tests in this package.
}
\details{
Function returns a matrix containing the thresholds used, the number of observations above each threshold,
the corresponding test statistics, p-values (raw and transformed), and parameter estimates at each threshold. The user must provide
the data, a vector of thresholds or number of upper extremes to be used, and select the test.
}
\examples{
set.seed(7)
x <- rgpd(10000, loc = 0, scale = 5, shape = 0.2)
## A vector of thresholds to test
threshes <- c(1.5, 2.5, 3.5, 4.5, 5.5)
gpdSeqTests(x, thresholds = threshes, method = "ad")
}

