% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{run_simulations}
\alias{run_simulations}
\title{Run simulations for a list of scenarios}
\usage{
run_simulations(
  scenario,
  ...,
  iterations = 10000L,
  ale_maximum = NULL,
  verbose = FALSE,
  simulation_count = NULL
)
}
\arguments{
\item{scenario}{A \link{tidyrisk_scenario} object.}

\item{...}{Additional \code{tidyrisk_scenario} objects to simulate.}

\item{iterations}{Number of iterations to run on each scenario.}

\item{ale_maximum}{Maximum practical annual losses.}

\item{verbose}{Whether verbose console output is requested.}

\item{simulation_count}{\strong{DEPRECATED} Number of simulations to perform.}
}
\value{
A list of one dataframe of results for each scenario.
}
\description{
Given a list of quantitative scenario objects of type \code{tidyrisk_scenario},
run a OpenFAIR Monte Carlo simulation for each scenario.
}
\examples{
# fetch three scenarios for this example
data(mc_quantitative_scenarios)
scenario_a <- mc_quantitative_scenarios$scenario[[1]]
scenario_b <- mc_quantitative_scenarios$scenario[[2]]
scenario_c <- mc_quantitative_scenarios$scenario[[3]]
run_simulations(scenario_a, scenario_b, scenario_c, iterations = 10)

}
