% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_excel_flex.R
\name{read_excel_flex}
\alias{read_excel_flex}
\title{Flexible Excel reader}
\usage{
read_excel_flex(
  file_path,
  sheet = 1,
  skip = 0,
  header = TRUE,
  range = NULL,
  col_types = NULL,
  clean_names = TRUE,
  guess_max = 1000,
  trim_ws = TRUE,
  na = "",
  verbose = TRUE
)
}
\arguments{
\item{file_path}{Path to the Excel file (.xlsx or .xls).}

\item{sheet}{Sheet name or index to read (default: 1).}

\item{skip}{Number of lines to skip before reading data (default: 0).}

\item{header}{Logical. Whether the first row contains column names (default: TRUE).}

\item{range}{Optional cell range (e.g., \code{"B2:D100"}). Default: \code{NULL}.}

\item{col_types}{Optional vector specifying column types; passed to \code{readxl}.}

\item{clean_names}{Logical. Clean column names with \code{janitor::clean_names()} (default: TRUE).}

\item{guess_max}{Max rows to guess column types (default: 1000).}

\item{trim_ws}{Logical. Trim surrounding whitespace in text fields (default: TRUE).}

\item{na}{Values to interpret as NA (default: \code{""}).}

\item{verbose}{Logical. Show CLI output (default: TRUE).}
}
\value{
A tibble (or data.frame) read from the Excel sheet.
}
\description{
Read an Excel sheet via \code{readxl::read_excel()} with optional column-name
cleaning (\code{janitor::clean_names()}), basic type control, and CLI messages.
}
