% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudoglm-methods.R
\name{confint.pseudoglm}
\alias{confint.pseudoglm}
\title{Confidence Intervals for pseudoglm Model Parameters}
\usage{
\method{confint}{pseudoglm}(object, parm, level = 0.95, type = "robust", ...)
}
\arguments{
\item{object}{A fitted model object from \link{cumincglm} or \link{rmeanglm}}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{type}{The type of variance estimate to use, see \link{vcov.pseudoglm}}

\item{...}{Not used}
}
\value{
A matrix (or vector) with columns giving lower and upper confidence limits for each parameter. These will be labelled as (1-level)/2 and 1 - (1-level)/2 in % (by default 2.5% and 97.5%).
}
\description{
Computes Wald confidence intervals for one or more parameters in a fitted model. Users can specify the type of variance estimate used, with the default being the robust sandwich variance estimator.
}
\examples{
cumincipcw <- cumincglm(survival::Surv(etime, event) ~ age + sex,
         time = 200, cause = "pcm", link = "identity",
         model.censoring = "independent", data = mgus2)
confint(cumincipcw)

}
