% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{summary.evgam}
\alias{summary.evgam}
\alias{print.summary.evgam}
\title{Summary method for a fitted \code{evgam} object}
\usage{
\method{summary}{evgam}(object, ...)

\method{print}{summary.evgam}(x, ...)
}
\arguments{
\item{object}{a fitted \code{evgam} object}

\item{...}{not used}

\item{x}{a \code{summary.evgam} object}
}
\value{
A \code{summary.evgam} object
}
\description{
Summary method for a fitted \code{evgam} object
}
\details{
The key part of summary.evgam is p-values for smooths.
The tests use code directly taken from \code{mgcv 1.8-14}. This is 
to avoid use of \code{mgcv:::...} . Tests implement the method of
Wood (2013).
}
\examples{

\donttest{

library(evgam)
data(COprcp)
COprcp$year <- format(COprcp$date, "\%Y")
COprcp_gev <- aggregate(prcp ~ year + meta_row, COprcp, max)
COprcp_gev <- cbind(COprcp_gev, COprcp_meta[COprcp_gev$meta_row,])
fmla_gev <- list(prcp ~ s(lon, lat, k=30) + s(elev, bs="cr"), ~ s(lon, lat, k=20), ~ 1)
m_gev <- evgam(fmla_gev, data=COprcp_gev, family="gev")
summary(m_gev)

}

}
\references{
Wood, S. N., (2013) On p-values for smooth components of an extended
generalized additive model, Biometrika 100(1) 221--228
}
