% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_confint_gev.R
\name{confint_gev_methods}
\alias{confint_gev_methods}
\alias{print.confint_gev}
\alias{plot.confint_gev}
\title{Methods for objects of class \code{"confint_gev"}}
\usage{
\method{print}{confint_gev}(x, ...)

\method{plot}{confint_gev}(x, parm = c("mu", "sigma", "xi"), add = TRUE, digits = 2, ...)
}
\arguments{
\item{x}{An object inheriting from class \code{"confint_gev"}, an object returned
after a call to \code{\link{confint.evmissing}}.}

\item{...}{Further arguments. For \code{print.confint_gev} to pass arguments to
\code{\link{print}}. For \code{plot.confint_gev} to pass graphical parameters to
\code{\link[graphics:plot.default]{plot}} to create the initial plot of the profile
log-likelihood.}

\item{parm}{A character scalar specifying the parameter for which
a profile log-likelihood is plotted. Must be a single component of
\code{c("mu", "sigma", "xi")}.}

\item{add}{A logical scalar. If \code{add = TRUE} then the plot is annotated with
a horizontal line indicating the critical value for the profile
log-likelihood used to calculate the confidence limits, vertical lines
indicating the values of these limits and a legend stating the
confidence interval.}

\item{digits}{An integer. Passed to \code{\link{signif}} to round the confidence
limits in the legend, if \code{add = TRUE}.}
}
\value{
\code{print.confint_gev}: the argument \code{x} is returned, invisibly.

\code{plot.confint_gev}: a numeric vector containing the confidence limits for
the parameter requested in \code{parm} is returned invisibly.
}
\description{
Methods for objects of class \code{"confint_gev"} returned from
\code{\link{confint.evmissing}}.
}
\details{
\code{print.confint_gev}. A numeric matrix with 2 columns giving the
lower and upper confidence limits for the parameters specified by the
argument \code{parm} in \code{\link{confint.evmissing}}. These columns are labelled as
\code{(1-level)/2} and \code{1-(1-level)/2}, expressed as a percentage, by default
\verb{2.5\%} and \verb{97.5\%}.

\code{plot.confint_gev}. A plot is produced of the profile log-likelihood for
the parameter chosen by \code{parm}. Only the parameter values used to profile
the log-likelihood in the call to \code{\link{confint.evmissing}} are included, so
if \code{faster = TRUE} was used then the plot will not be of a smooth curve
but will be triangular in the middle.
}
\section{Examples}{
 See \code{\link{evmissing_methods}}.
}

\seealso{
\code{\link{gev_mle}} and \code{\link{evmissing_methods}}.
}
