% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{BloomsburyOzoneMaxima}
\alias{BloomsburyOzoneMaxima}
\title{Annual maxima ozone levels at Bloomsbury, UK}
\format{
\code{BloomsburyOzoneMaxima} is a data frame with 33 rows (years 1992 to
2024) and the 4 variables:
\itemize{
\item \code{maxima}: annual maximum ozone level in \eqn{\mu}g/m\eqn{^3}.
\item \code{notNA} : the number of days of the year for which raw data were available.
\item \code{n} : the number of days in the year (365 or 366).
\item \code{block} : a block number of 1 for year 1992 through to 33 for year 2024.
}

The row names of \code{BloomsburyOzoneMaxima} are the years \code{1992:2024}.
The raw data are missing for approximately \eqn{5\%} of the days.
}
\source{
The Department for Environment Food and Rural Affair (DEFRA).
The London Bloomsbury monitoring site at
the \href{https://uk-air.defra.gov.uk/}{UK-AIR} database
\href{https://uk-air.defra.gov.uk/data/data_selector}{Data Selector}.
}
\usage{
BloomsburyOzoneMaxima
}
\description{
Annual maxima of daily maximum ozone levels at Bloomsbury in London (UK)
for the years 1992-2024 inclusive.
}
\examples{
head(BloomsburyOzoneMaxima)

# Time series plot of annual maxima ozone levels
plot(rownames(BloomsburyOzoneMaxima), BloomsburyOzoneMaxima$maxima,
     ylab = "ozone (micrograms / metre cubed)", xlab = "year", pch = 16)

# Time series plot of proportion of non-missing days
plot(rownames(BloomsburyOzoneMaxima),
     BloomsburyOzoneMaxima$notNA / BloomsburyOzoneMaxima$n,
     ylab = "proportion of non-missing days", xlab = "year", pch = 16)

# Plot ozone levels against the proportion of non-missing days
plot(BloomsburyOzoneMaxima$notNA / BloomsburyOzoneMaxima$n,
     BloomsburyOzoneMaxima$maxima,
     ylab = "ozone (micrograms / metre cubed)",
     xlab = "proportion of non-missing days", pch = 16)
}
\seealso{
\code{\link{BloomsburyOzone}} for the raw time series.
}
\keyword{datasets}
