\name{checking}
\alias{check.bcmethod}
\alias{check.control}
\alias{check.inputn}
\alias{check.logic}
\alias{check.n}
\alias{check.nn}
\alias{check.nparam}
\alias{check.offset}
\alias{check.optim}
\alias{check.param}
\alias{check.phiu}
\alias{check.posparam}
\alias{check.prob}
\alias{check.quant}
\alias{check.text}
\alias{checking}
\title{Functions for checking function input argument}
\usage{
  check.quant(x, allowvec = TRUE, allownull = FALSE,
    allowmiss = FALSE, allowinf = FALSE)

  check.prob(prob, allowvec = TRUE, allownull = FALSE,
    allowmiss = FALSE)

  check.n(n)

  check.param(param, allowvec = FALSE, allownull = FALSE,
    allowmiss = FALSE, allowinf = FALSE)

  check.posparam(param, allowvec = FALSE,
    allownull = FALSE, allowmiss = FALSE, allowinf = FALSE)

  check.logic(logicarg, allowvec = FALSE, allowna = FALSE)

  check.nparam(param, nparam = 1, allownull = FALSE)

  check.text(textarg, allowvec = FALSE)

  check.inputn(inputn, allowvec = TRUE)

  check.phiu(phiu, allowvec = FALSE, allownull = FALSE,
    allowfalse = FALSE)

  check.optim(method)

  check.control(control)

  check.bcmethod(bcmethod)

  check.nn(nn)

  check.offset(offset, bcmethod)
}
\arguments{
  \item{x}{scalar or vector of quantiles}

  \item{prob}{scalar or vector of probability}

  \item{n}{scalar sample size}

  \item{param}{scalar or vector of parameters}

  \item{phiu}{scalar or vector of phiu (logical, NULL or
  0-1 exclusive)}

  \item{nparam}{vector of lengths of parameter vectors}

  \item{logicarg}{logical input argument}

  \item{textarg}{character input argument}

  \item{inputn}{vector of input lengths}

  \item{allowvec}{logical, where TRUE permits vector}

  \item{allownull}{logical, where TRUE permits NULL values}

  \item{allowmiss}{logical, where TRUE permits NA and NaN
  values}

  \item{allowna}{logical, where TRUE permits NA values}

  \item{allowinf}{logical, where TRUE permits Inf values}

  \item{allowfalse}{logical, where TRUE permits FALSE (and
  TRUE) values}

  \item{method}{optimisation method (see
  \code{\link[stats:optim]{optim}})}

  \item{control}{optimisation control list (see
  \code{\link[stats:optim]{optim}})}

  \item{bcmethod}{boundary correction method}

  \item{nn}{non-negativity correction method (simple
  boundary correction only)}

  \item{offset}{offset added to kernel centres (logtrans
  only) or \code{NULL}}
}
\value{
  The checking functions will stop on errors and return no
  value. The only exception is the
  \code{\link[evmix:checking]{check.inputn}} which outputs
  the maximum vector length.
}
\description{
  Functions for checking the input arguments to functions,
  so that main functions are more concise. They will stop
  when an inappropriate input is found.

  For likelihood functions you will often not want to stop
  on finding a non-positive values for postive parameters,
  in such cases use
  \code{\link[evmix:checking]{check.param}} rather than
  \code{\link[evmix:checking]{check.posparam}}.
}
\author{
  Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}.
}

