% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaZ_corr.R
\name{DeltaZCorr}
\alias{DeltaZCorr}
\alias{DeltaZCorr.default}
\alias{DeltaZCorr.list}
\title{Compare matrices via the correlation between response vectors}
\usage{
DeltaZCorr(cov.x, cov.y, skewers, ...)

\method{DeltaZCorr}{default}(cov.x, cov.y, skewers, ...)

\method{DeltaZCorr}{list}(cov.x, cov.y = NULL, skewers, parallel = FALSE, ...)
}
\arguments{
\item{cov.x}{Single covariance matrix or list of covariance matrices.
If single matrix is supplied, it is compared to cov.y.
If list is supplied and no cov.y is supplied, all matrices
are compared.
If cov.y is supplied, all matrices in list are compared to it.}

\item{cov.y}{First argument is compared to cov.y.
Optional if cov.x is a list.}

\item{skewers}{matrix of column vectors to be used as gradients}

\item{...}{additional arguments passed to other methods.}

\item{parallel}{if TRUE computations are done in parallel. Some foreach back-end must be registered, like doParallel or doMC.}
}
\value{
vector of vector correlations between the expected responses for the two matrices for each supplied vector
}
\description{
Compares the expected response to selection for two matrices for a specific set of
selection gradients (not random gradients like in the RandomSkewers method)
}
\examples{
x <- RandomMatrix(10, 1, 1, 10)
y <- RandomMatrix(10, 1, 1, 10)

n_skewers = 10
skewers = matrix(rnorm(10*n_skewers), 10, n_skewers)
DeltaZCorr(x, y, skewers)

}
\references{
Cheverud, J. M., and Marroig, G. (2007). Comparing covariance matrices:
Random skewers method compared to the common principal components model.
Genetics and Molecular Biology, 30, 461-469.
}
\seealso{
\code{\link{KrzCor}},\code{\link{MantelCor}}
}
\author{
Diogo Melo, Guilherme Garcia
}
\keyword{matrixcomparison}
\keyword{matrixcorrelation}
\keyword{randomskewers}
