% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{get_dbscan_params}
\alias{get_dbscan_params}
\title{Get the minPts and eps values for DBSCAN to label only a specific percentage as noise}
\usage{
get_dbscan_params(
  sessions,
  MinPts,
  eps0,
  noise_th = 2,
  eps_offset_pct = 0.9,
  eps_inc_pct = 0.02,
  log = FALSE,
  start = getOption("evprof.start.hour")
)
}
\arguments{
\item{sessions}{tibble, sessions data set in evprof
\href{https://mcanigueral.github.io/evprof/articles/sessions-format.html}{standard format}.}

\item{MinPts}{DBSCAN MinPts parameter}

\item{eps0}{DBSCAN eps parameter corresponding to the elbow of kNN dist plot}

\item{noise_th}{noise threshold}

\item{eps_offset_pct}{eps_offset_pct}

\item{eps_inc_pct}{eps_inc_pct}

\item{log}{logical, whether to transform \code{ConnectionStartDateTime} and
\code{ConnectionHours} variables to natural logarithmic scale (base = \code{exp(1)}).}

\item{start}{integer, start hour in the x axis of the plot.
This is only used when \code{log = FALSE}.}
}
\value{
tibble with minPts and eps parameters, and the corresponding noise
}
\description{
Get the minPts and eps values for DBSCAN to label only a specific percentage as noise
}
