% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{divide_by_timecycle}
\alias{divide_by_timecycle}
\title{Divide sessions by time-cycle}
\usage{
divide_by_timecycle(
  sessions,
  months_cycles = list(1:12),
  wdays_cycles = list(1:5, 6:7),
  start = getOption("evprof.start.hour")
)
}
\arguments{
\item{sessions}{tibble, sessions data set in evprof
\href{https://mcanigueral.github.io/evprof/articles/sessions-format.html}{standard format}.}

\item{months_cycles}{list containing Monthly cycles}

\item{wdays_cycles}{list containing Weekdays cycles}

\item{start}{integer, start hour in the x axis of the plot.}
}
\value{
same sessions data set with extra column "Timecycle"
}
\description{
Divide sessions by time-cycle
}
\examples{
library(dplyr)
sessions_timecycles <- california_ev_sessions \%>\%
  sample_frac(0.05) \%>\%
  divide_by_timecycle(
    months_cycles = list(1:12),
    wdays_cycles = list(1:5, 6:7)
  )

# The column `Timecycle` has been added
names(sessions_timecycles)

library(ggplot2)
plot_points(sessions_timecycles) +
  facet_wrap(vars(Timecycle))

}
