% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02B_TestStatistics.R
\name{TestStatistics}
\alias{TestStatistics}
\title{Simple Test Statistics}
\usage{
TestStatistics(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{U is a data matrix of the type matrix or data.frame.}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}
}
\value{
For binary data:
\describe{
\item{TestLength}{Length of the test. The number of items included in the test.}
\item{SampleSize}{Sample size. The number of rows in the dataset.}
\item{Mean}{Average number of correct answers.}
\item{SEofMean}{Standard error of mean}
\item{Variance}{Variance}
\item{SD}{Standard Deviation}
\item{Skewness}{Skewness}
\item{Kurtosis}{Kurtosis}
\item{Min}{Minimum score}
\item{Max}{Max score}
\item{Range}{Range of score}
\item{Q1}{First quartile. Same as the 25th percentile.}
\item{Median}{Median. Same as the 50th percentile.}
\item{Q3}{Third quartile. Same as the 75th percentile.}
\item{IQR}{Interquartile range. It is calculated by subtracting the first quartile from the third quartile.}
\item{Stanine}{see \link{stanine}}
}
For rated polytomous data:
\describe{
\item{TestLength}{Length of the test. The number of items included in the test.}
\item{SampleSize}{Sample size. The number of rows in the dataset.}
\item{Mean}{Average number of correct answers.}
\item{SEofMean}{Standard error of mean}
\item{Variance}{Variance}
\item{SD}{Standard Deviation}
\item{Skewness}{Skewness}
\item{Kurtosis}{Kurtosis}
\item{Min}{Minimum score}
\item{Max}{Max score}
\item{Range}{Range of score}
#' }
For ordinal polytomous data:
\describe{
\item{TestLength}{Length of the test. The number of items included in the test.}
\item{SampleSize}{Sample size. The number of rows in the dataset.}
\item{Mean}{Average number of correct answers.}
\item{SEofMean}{Standard error of mean}
\item{Variance}{Variance}
\item{SD}{Standard Deviation}
\item{Skewness}{Skewness}
\item{Kurtosis}{Kurtosis}
\item{Min}{Minimum score}
\item{Max}{Max score}
\item{Range}{Range of score}
}
For nominal polytomous data:
\describe{
\item{Response Data}{Same as binary data, with scores representing response levels}
}
}
\description{
Statistics regarding the total score.
}
\examples{
# using sample dataset
TestStatistics(J15S500)
}
