% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view.R
\name{view}
\alias{view}
\title{Explore and Render Exam Exercises}
\usage{
view(
  action = c("topic", "file", "pdf", "html"),
  pattern = NULL,
  topic = TRUE,
  ...
)
}
\arguments{
\item{action}{Character. One of \code{"topic"}, \code{"file"}, \code{"pdf"}, or \code{"html"}.
\itemize{
\item \code{"topic"}: return the list of available exercise topics (subdirectories).
\item \code{"file"}: return the list of exercise filenames relative to \verb{aufgaben/}.
\item \code{"pdf"}: render selected exercises to PDF.
\item \code{"html"}: render selected exercises to HTML.
}}

\item{pattern}{Character or \code{NULL}. A regular expression to filter exercises.
If \code{topic = TRUE}, the pattern is matched against the directory names (topics).
If \code{topic = FALSE}, the pattern is searched inside the exercise files.}

\item{topic}{Logical. If \code{TRUE} (default), \code{pattern} is applied to directory names.
If \code{FALSE}, \code{pattern} is applied to the content of the exercise files.}

\item{...}{Additional arguments passed to \code{grepl()} when filtering files or contents.}
}
\value{
A character vector of topics or filenames, or \code{NULL} if no exercises are found.
When rendering (\code{pdf}/\code{html}), the files are rendered silently with messages and warnings suppressed.
}
\description{
This function allows the user to explore exercises from the \code{exams.forge.data} package
and optionally render them to PDF or HTML. Users can filter exercises by directory (topic)
or by a pattern in filenames or file contents.
}
\examples{
\donttest{
view("topic")

# List all files in a specific topic
view("file", pattern = "ttest", topic = TRUE)

if (interactive()) {
# Render the files matching a pattern to HTML
  view("file", pattern = "hyper")
  view("html", pattern = "hyper")
}
}

}
