% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI_data.R
\name{CImu_data}
\alias{CImu_data}
\alias{dcimu}
\title{Confidence Intervals for a Population Mean}
\usage{
CImu_data(
  x = NULL,
  n = length(x),
  xbar = NULL,
  sd = NULL,
  conf.level = c(0.9, 0.95, 0.99),
  mu = NULL,
  sigma = NULL
)

dcimu(
  x = NULL,
  n = length(x),
  xbar = NULL,
  sd = NULL,
  conf.level = c(0.9, 0.95, 0.99),
  mu = NULL,
  sigma = NULL
)
}
\arguments{
\item{x}{numeric vector of observed data. If \code{NULL}, data are simulated.}

\item{n}{integer: sample size (if \code{n < 1}, defaults to \code{5}).}

\item{xbar}{numeric: sample mean (computed from \code{x} if \code{NULL}).}

\item{sd}{numeric: sample standard deviation (computed from \code{x} if \code{NULL}).}

\item{conf.level}{numeric vector of confidence levels (default: \code{c(0.9, 0.95, 0.99)}).}

\item{mu}{numeric: true population mean (used for simulation if \code{x} is \code{NULL}).}

\item{sigma}{numeric: population standard deviation(s) (used for simulation if \code{x} is \code{NULL}).}
}
\value{
A list containing:
\item{a}{upper-tail probability \code{1 - (1 - conf.level) / 2}}
\item{n}{sample size}
\item{xbar}{sample mean}
\item{mu}{theoretical mean (if provided)}
\item{sd}{sample standard deviation}
\item{sigma}{theoretical standard deviation (if provided)}
\item{df}{degrees of freedom (if using a \emph{t} distribution)}
\item{q}{critical value(s) from the normal or \emph{t} distribution}
\item{ss}{standard deviation used in calculations (\code{sd} or \code{sigma})}
\item{e}{margin of error (half-width of the interval)}
\item{l}{interval length}
\item{v}{confidence interval endpoints}
}
\description{
Computes confidence intervals for a population mean (\code{mu}) using either
supplied data or data generated from a normal distribution with specified
parameters. The function calculates key statistics such as the sample mean,
standard deviation, and confidence intervals at user-defined confidence levels.
Results are returned as a structured list containing observed and/or theoretical
values, interval endpoints, and related measures.
}
\examples{
# Using observed data
x <- rnorm(100)
CImu_data(x, conf.level = 0.95)

# Simulating data internally
CImu_data(n = 100, conf.level = 0.95, mu = 0, sigma = 1)
}
