\name{exams2canvas}
\alias{exams2canvas}

\title{Generation of Exams for Canvas}

\description{
  Automatic generation of exams in QTI 1.2 with some tweaks
  (still under development) for the learning management system Canvas.
}

\usage{
  exams2canvas(file, n = 1L, dir = ".", name = "canvasquiz",
    maxattempts = 1, duration = NULL, points = NULL,
    converter = NULL, \dots)
}

\arguments{
  \item{file}{character. A specification of a (list of) exercise files.}
  \item{n}{integer. The number of copies to be compiled from \code{file}.}
  \item{dir}{character. The default is the current working directory.}
  \item{name}{character. A name prefix for resulting exercises and ZIP file.}
  \item{maxattempts}{integer. The maximum attempts for one question
    (must be smaller than \code{100000}).}
  \item{duration}{integer. Set the duration of the exam in minutes.}
  \item{points}{integer. How many points should be assigned to each exercise? Note that this
    argument overules any exercise points that are provided within an \code{"\expoints{}"} tag
    in the \code{.Rnw} file. The vector of points supplied is expanded to the number of exercises in
    the exam.}
  \item{converter}{character passed on to \code{\link[exams]{make_exercise_transform_html}},
    indicating the type of converter from LaTeX/Markdown to HTML. Currently,
    Canvas requires HTML with MathML. Hence, if there are Markdown-based .Rmd
    exercises, the \code{converter} needs to be \code{"pandoc-mathml"} (or
    equivalently \code{"pandoc"}). For only LaTeX-based .Rnw exercises \code{"ttm"}
    can be used as an alternative and is currently the default.}
  \item{\dots}{arguments passed on to \code{\link[exams]{exams2qti12}}.
    The arguments \code{base64} and \code{eval} cannot be modified but are
    hard-coded internally (for details see below).}
}

\details{
  \code{exams2canvas} is a convenience interface to \code{\link[exams]{exams2qti12}}
  for generating QTI 1.2 with some small tweaks for Canvas
  (\url{https://www.instructure.com/canvas/}). The supported exercise types at the
  moment are num, schoice, mchoice, and string (but not cloze, yet). It is still under
  development and may change in future versions. Please report any problems to the package
  maintainer.
  
  The Canvas-specific tweaks include:
  \itemize{
    \item Canvas necessitates a \code{converter} that produces HTML plus MathML.
      Thus, \code{"pandoc-mathml"} (or equivalently \code{"pandoc"}) can be used
      or alternatively \code{"ttm"} for exams with only R/LaTeX .Rnw exercises.
    \item Supplementary files (images, data, ...) must be embedded without Base 64
      encoding. Thus, \code{base64 = FALSE} is hard-coded internally in \code{exams2canvas}.
    \item Multiple-choice exercises (referred to as multiple answer questions in Canvas)
      are always evaluated (aka scored) with partial credits in Canvas. Therefore,
      \code{eval = list(partial = TRUE, negative = FALSE)} is hard-coded internally
      in \code{exams2canvas}. Negative points are not supported in Canvas.
    \item The QTI XML file requires a few special tags which are enforced through
      \code{flavor = "canvas"} in \code{exams2qti12}.
  }
  
  \emph{Technical note:} For multiple-choice questions the QTI XML file produced by
  \code{exams2canvas} appears to encode an \dQuote{all-or-nothing} scheme without partial
  credits (i.e., \code{partial = FALSE}). However, this is necessary for Canvas to recognize
  the answer alternatives correctly. Despite this, Canvas always applies partial-credit
  evaluation (as explained above).
}

\value{
  \code{exams2canvas} returns a list of exams as generated by \code{\link[exams]{xexams}}.
}

\seealso{
  \code{\link[exams]{exams2qti12}}
}

\examples{
\donttest{
## load package and enforce par(ask = FALSE)
library("exams")
options(device.ask.default = FALSE)

## define an exams (= list of exercises)
myexam <- c(
  "boxplots",
  "tstat",
  "ttest",
  "regression",
  "relfreq"
)

## output directory
dir.create(mydir <- tempfile())

## generate .zip with OpenOLAT test in temporary directory
exams2canvas(myexam, n = 3, dir = mydir)
dir(mydir)
}
}

\keyword{utilities}
