/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class ExPANdS {
    public static final int DEFAULT_MAX_PM = 6;
    private static final int SNVONLY_FLAG = 1;
    private static final int CNVONLY_FLAG = 2;
    private static final int SNVANDCNV_FLAG = 3;
    private static final int SNVBEFORECNV_FLAG = 4;
    private static int PN = 2;
    private List<FitAlternatives> solutions;
    private double CN;
    private double AF;
    private static double maxCN_Error = 0.1;
    private int PN_B;
    private double minErr;
    private double[] alternativeCN;
    private FitAlternatives bestSolution;
    private int max_PM;
    private int PM = Integer.MIN_VALUE;
    private double f_CNV = Double.NaN;
    public static final String[] SOLUTION_ENTITIES = new String[]{"PN", "PN_B", "PM", "PM_B", "CN_Estimate", "AF_Tumor", "f", "dev"};

    public double getDeviation() {
        return this.minErr;
    }

    public ExPANdS(double af, double cn, int pnb, int max_PM) {
        this.max_PM = max_PM;
        this.PN_B = pnb;
        this.init(af, cn);
    }

    public ExPANdS(double af, double cn, double f_cnv, int PM, int pnb) {
        this.f_CNV = f_cnv;
        this.PM = PM;
        this.PN_B = pnb;
        this.init(af, cn);
    }

    private void init(double af, double cn) {
        this.bestSolution = new FitAlternatives(1, -1, -1);
        this.bestSolution.set(0, Double.NaN, Double.NaN);
        this.AF = af;
        this.CN = cn;
        double step = 0.005;
        int alt = (int)Math.floor((this.CN + maxCN_Error - Math.max(0.0, this.CN - maxCN_Error)) / step);
        this.alternativeCN = new double[alt];
        this.alternativeCN[0] = Math.max(0.0, this.CN - maxCN_Error);
        int i = 1;
        while (i < this.alternativeCN.length) {
            this.alternativeCN[i] = this.alternativeCN[i - 1] + step;
            ++i;
        }
    }

    public void run(int snv_cnv_flag) {
        if (snv_cnv_flag == 1) {
            this.runSNVonly();
        } else if (snv_cnv_flag == 2) {
            this.runCNVonly();
        } else if (snv_cnv_flag == 3) {
            this.runSNVandCNV();
        } else if (snv_cnv_flag == 4) {
            if (Double.isNaN(this.f_CNV) || this.f_CNV <= 0.0) {
                System.err.println("The size of the subpopulation harboring the CNV is set to " + this.f_CNV + ". Invalid value for selected evolutionary scenario. Aborting.");
                System.exit(1);
            }
            this.runSNVbeforeCNV();
        } else {
            System.err.print("Invalid value found for snv_cnv_flag: " + snv_cnv_flag + ". Valid values are: 1 (SNV only), 2 (CNV only) or 3 (SNV and CNV). ");
            System.exit(1);
        }
    }

    private void runSNVandCNV() {
        int min_PM = 1;
        this.minErr = Double.POSITIVE_INFINITY;
        int nIter = this.max_PM - min_PM + 1;
        int[][] PM = new int[nIter][nIter];
        int[][] PM_B = new int[nIter][nIter];
        this.solutions = new ArrayList<FitAlternatives>(PM.length * PM_B.length);
        int pm = min_PM;
        while (pm <= this.max_PM) {
            double copyPenality = 1.0;
            int pmb = min_PM;
            while (pmb <= pm) {
                if (!((double)pmb / (double)pm <= (double)this.PN_B / (double)PN)) {
                    Array2DRowRealMatrix coefficients = new Array2DRowRealMatrix(new double[][]{{pm - PN}, {pmb - this.PN_B}}, false);
                    int i = pm - min_PM;
                    int j = pmb - min_PM;
                    PM[i][j] = pm;
                    PM_B[i][j] = pmb;
                    FitAlternatives alternatives = new FitAlternatives(this.alternativeCN.length, pm, pmb);
                    int k = 0;
                    while (k < this.alternativeCN.length) {
                        double cn = this.alternativeCN[k];
                        ArrayRealVector constants = new ArrayRealVector(new double[]{cn - (double)PN, cn * this.AF - (double)this.PN_B}, false);
                        this.solve(coefficients, constants, copyPenality, cn, alternatives, k);
                        ++k;
                    }
                    this.solutions.add(alternatives);
                }
                ++pmb;
            }
            ++pm;
        }
    }

    private void runSNVbeforeCNV() {
        this.minErr = Double.POSITIVE_INFINITY;
        this.solutions = new ArrayList<FitAlternatives>(this.PM * 2);
        int pmb = 1;
        while (pmb <= 2) {
            ArrayRealVector constants;
            double cn;
            int k;
            FitAlternatives alternatives;
            Array2DRowRealMatrix coefficients;
            int pmb_f;
            double copyPenality = 1.0;
            if ((double)pmb / 2.0 > (double)this.PN_B / (double)PN && this.PM <= 2) {
                pmb_f = 1;
                while (pmb_f <= Math.max(1, Math.min(pmb, 2 - this.PM))) {
                    coefficients = new Array2DRowRealMatrix(new double[][]{{pmb + pmb_f - this.PN_B}}, false);
                    alternatives = new FitAlternatives(this.alternativeCN.length, -1, pmb);
                    k = 0;
                    while (k < this.alternativeCN.length) {
                        cn = this.alternativeCN[k];
                        constants = new ArrayRealVector(new double[]{cn * this.AF + (double)pmb_f * this.f_CNV - (double)this.PN_B}, false);
                        this.solve(coefficients, constants, copyPenality, cn, alternatives, k);
                        ++k;
                    }
                    this.solutions.add(alternatives);
                    ++pmb_f;
                }
            }
            if (this.PM >= 2) {
                pmb_f = pmb + 1;
                while (pmb_f <= this.PM) {
                    if (!(Math.max((double)pmb / 2.0, (double)(pmb_f / this.PM)) <= (double)this.PN_B / (double)PN)) {
                        coefficients = new Array2DRowRealMatrix(new double[][]{{pmb - pmb_f - this.PN_B}}, false);
                        alternatives = new FitAlternatives(this.alternativeCN.length, -1, pmb);
                        k = 0;
                        while (k < this.alternativeCN.length) {
                            cn = this.alternativeCN[k];
                            constants = new ArrayRealVector(new double[]{cn * this.AF - (double)pmb_f * this.f_CNV - (double)this.PN_B}, false);
                            this.solve(coefficients, constants, copyPenality, cn, alternatives, k);
                            ++k;
                        }
                        this.solutions.add(alternatives);
                    }
                    ++pmb_f;
                }
            }
            ++pmb;
        }
    }

    private void solve(RealMatrix coefficients, RealVector constants, double copyPenality, double cn, FitAlternatives alternatives, int k) {
        DecompositionSolver solver = new SingularValueDecomposition(coefficients).getSolver();
        RealVector solution = solver.solve(constants);
        RealVector errorterm = coefficients.operate(solution).subtract(constants);
        double sumErr = Math.abs(this.CN - cn);
        int i = 0;
        while (i < errorterm.getDimension()) {
            sumErr += Math.abs(errorterm.getEntry(i));
            ++i;
        }
        alternatives.set(k, solution.getEntry(0), sumErr *= copyPenality);
        if (solution.getEntry(0) > -0.1 && solution.getEntry(0) <= 1.1 && this.minErr > sumErr) {
            this.minErr = sumErr;
            this.bestSolution = alternatives;
        }
    }

    private void runSNVonly() {
        int min_PM = 1;
        this.minErr = Double.POSITIVE_INFINITY;
        int nIter = this.max_PM - min_PM + 1;
        int[] PM_B = new int[nIter];
        this.solutions = new ArrayList<FitAlternatives>(PM_B.length);
        int pmb = min_PM;
        while (pmb <= this.max_PM) {
            double copyPenality = 1.0;
            Array2DRowRealMatrix coefficients = new Array2DRowRealMatrix(new double[][]{{pmb - this.PN_B}}, false);
            int j = pmb - min_PM;
            PM_B[j] = pmb;
            FitAlternatives alternatives = new FitAlternatives(this.alternativeCN.length, -1, pmb);
            int k = 0;
            while (k < this.alternativeCN.length) {
                double cn = this.alternativeCN[k];
                ArrayRealVector constants = new ArrayRealVector(new double[]{cn * this.AF - (double)this.PN_B}, false);
                this.solve(coefficients, constants, copyPenality, cn, alternatives, k);
                ++k;
            }
            this.solutions.add(alternatives);
            ++pmb;
        }
    }

    private void runCNVonly() {
        int min_PM = 0;
        this.minErr = Double.POSITIVE_INFINITY;
        int nIter = this.max_PM - min_PM + 1;
        int[] PM = new int[nIter];
        this.solutions = new ArrayList<FitAlternatives>(PM.length);
        int pm = min_PM;
        while (pm <= this.max_PM) {
            double copyPenality = 1.0;
            Array2DRowRealMatrix coefficients = new Array2DRowRealMatrix(new double[][]{{pm - PN}}, false);
            int i = pm - min_PM;
            PM[i] = pm;
            FitAlternatives alternatives = new FitAlternatives(this.alternativeCN.length, pm, -1);
            int k = 0;
            while (k < this.alternativeCN.length) {
                double cn = this.alternativeCN[k];
                ArrayRealVector constants = new ArrayRealVector(new double[]{cn - (double)PN}, false);
                this.solve(coefficients, constants, copyPenality, cn, alternatives, k);
                ++k;
            }
            this.solutions.add(alternatives);
            ++pm;
        }
    }

    public int getPM_B() {
        return this.bestSolution.getPM_B();
    }

    public int getPM() {
        return this.bestSolution.getPM();
    }

    public double getF() {
        try {
            return this.bestSolution.getBest().getF();
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public void printFitsToFile(File f) throws IOException {
        BufferedWriter w = Common.getWriter(f.getAbsolutePath());
        w.write(Common.toString(SOLUTION_ENTITIES, "\t"));
        w.newLine();
        for (FitAlternatives fits : this.solutions) {
            Iterator<Solution> iter = fits.iterator();
            while (iter.hasNext()) {
                w.write(iter.next().toString());
                w.newLine();
            }
        }
        w.flush();
        w.close();
    }

    public Collection<FitAlternatives> solutions() {
        return this.solutions;
    }

    public static void main(String[] args) {
        ExPANdS expandsa = new ExPANdS(0.39, 1.33, 0.66, 1, 0);
        expandsa.runSNVbeforeCNV();
        Object[] files = new File(System.getProperty("user.dir")).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(".snv");
            }
        });
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object f = objectArray[n2];
            System.out.println(((File)f).getName());
            File pair = new File(String.valueOf(((File)f).getAbsolutePath()) + ".expands");
            if (pair.exists()) {
                System.out.println("ExPANdS file for " + ((File)f).getName() + " already exists. Skipped.");
            } else {
                int count = 0;
                try {
                    BufferedReader r = Common.getReader(((File)f).getAbsolutePath());
                    BufferedWriter w = Common.getWriter(pair.getAbsolutePath());
                    Object[] header = r.readLine().trim().split("\\s+");
                    w.write(Common.toString((String[])header, "\t"));
                    w.newLine();
                    int countI = Common.firstIndexOf("Count", header);
                    int afI = Common.firstIndexOf("AF_Tumor", header);
                    int cnI = Common.firstIndexOf("CN_Estimate", header);
                    int pnbI = Common.firstIndexOf("PN_B", header);
                    int pABBBI = Common.firstIndexOf("pABBB", header);
                    int pAABBI = Common.firstIndexOf("pAABB", header);
                    int pAAABI = Common.firstIndexOf("pAAAB", header);
                    int fI = Common.firstIndexOf("f", header);
                    int pmI = Common.firstIndexOf("PM", header);
                    int pmbI = Common.firstIndexOf("PM_B", header);
                    int devI = Common.firstIndexOf("dev", header);
                    String l = r.readLine();
                    while (l != null) {
                        String[] features = l.trim().split("\t");
                        if (features.length > header.length) {
                            features = Arrays.copyOfRange(features, 1, features.length);
                        }
                        int id = (int)Double.parseDouble(features[countI]);
                        int pnb = (int)Math.round(Double.parseDouble(features[pABBBI]));
                        try {
                            ExPANdS expands = new ExPANdS(Double.parseDouble(features[afI]), Double.parseDouble(features[cnI]), pnb, 6);
                            expands.run(3);
                            double pAABB = Double.parseDouble(features[pAABBI]);
                            double pABBB = Double.parseDouble(features[pABBBI]);
                            double pAAAB = Double.parseDouble(features[pAAABI]);
                            if (pABBB >= 0.5 || pAABB + pAAAB >= 0.9) {
                                expands.printFitsToFile(new File(String.valueOf(((File)f).getAbsolutePath()) + "." + id + ".fit"));
                                ++count;
                            }
                            features[pmI] = "" + expands.getPM();
                            features[pmbI] = "" + expands.getPM_B();
                            features[fI] = "" + expands.getF();
                            features[devI] = "" + expands.getDeviation();
                            features[pnbI] = "" + pnb;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        w.write(Common.toString(features, "\t").replace("Infinity", "Inf"));
                        w.newLine();
                        l = r.readLine();
                    }
                    w.flush();
                    w.close();
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public class FitAlternatives
    implements Iterator<Solution>,
    Iterable<Solution> {
        private double[] f;
        private double[] dev;
        private int pm;
        private int pmb;
        int idx = -2;

        private FitAlternatives(int numberAlternatives, int pm, int pmb) {
            this.f = new double[numberAlternatives];
            this.dev = new double[numberAlternatives];
            this.pm = pm;
            this.pmb = pmb;
        }

        public int getPM_B() {
            return this.pmb;
        }

        public int getPM() {
            return this.pm;
        }

        @Override
        public Iterator<Solution> iterator() {
            this.idx = -1;
            return this;
        }

        public double getF(int k) {
            return this.f[k];
        }

        public double getDev(int k) {
            return this.dev[k];
        }

        public int size() {
            return this.dev.length;
        }

        public Solution getBest() {
            int bestIdx = Common.argmin(this.dev);
            return new Solution(PN, ExPANdS.this.PN_B, this.pm, this.pmb, ExPANdS.this.CN, ExPANdS.this.AF, this.f[bestIdx], this.dev[bestIdx]);
        }

        void set(int i, double f, double dev) {
            this.f[i] = f;
            this.dev[i] = dev;
        }

        @Override
        public boolean hasNext() {
            return this.idx > -2 && this.idx < this.f.length - 1;
        }

        @Override
        public Solution next() {
            ++this.idx;
            if (this.idx >= this.dev.length) {
                return null;
            }
            return new Solution(PN, ExPANdS.this.PN_B, this.pm, this.pmb, ExPANdS.this.CN, ExPANdS.this.AF, this.f[this.idx], this.dev[this.idx]);
        }

        @Override
        public void remove() {
        }
    }

    public final class Solution {
        private double f;
        private double AF;
        private double CN;
        private int PM_B;
        private int PM;
        private int PN_B;
        private int PN;
        private double dev;

        public Solution(int PN, int PN_B, int PM, int PM_B, double CN, double AF, double f, double dev) {
            this.PN = PN;
            this.PN_B = PN_B;
            this.PM = PM;
            this.PM_B = PM_B;
            this.CN = CN;
            this.AF = AF;
            this.f = f;
            this.dev = dev;
        }

        public double getF() {
            return this.f;
        }

        public double[] toDouble() {
            return new double[]{this.PN, this.PN_B, this.PM, this.PM_B, this.CN, this.AF, this.f, this.dev};
        }

        public String toString() {
            return Common.toString(this.toDouble(), "\t");
        }
    }
}

