/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.function.Add;
import org.apache.commons.math3.analysis.function.Divide;
import org.apache.commons.math3.analysis.function.Multiply;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.OpenMapRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SparseRealVector;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RealVector {
    public abstract int getDimension();

    public abstract double getEntry(int var1);

    public abstract void setEntry(int var1, double var2);

    public void addToEntry(int index, double increment) {
        this.setEntry(index, this.getEntry(index) + increment);
    }

    public abstract RealVector append(RealVector var1);

    public abstract RealVector append(double var1);

    public abstract RealVector getSubVector(int var1, int var2);

    public abstract void setSubVector(int var1, RealVector var2);

    public abstract boolean isNaN();

    public abstract boolean isInfinite();

    protected void checkVectorDimensions(RealVector v) {
        this.checkVectorDimensions(v.getDimension());
    }

    protected void checkVectorDimensions(int n) {
        int d = this.getDimension();
        if (d != n) {
            throw new DimensionMismatchException(d, n);
        }
    }

    protected void checkIndex(int index) {
        if (index < 0 || index >= this.getDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)index, 0, this.getDimension() - 1);
        }
    }

    public RealVector add(RealVector v) {
        Entry e;
        RealVector result = v.copy();
        Iterator<Entry> it = this.sparseIterator();
        while (it.hasNext() && (e = it.next()) != null) {
            int index = e.getIndex();
            result.setEntry(index, e.getValue() + result.getEntry(index));
        }
        return result;
    }

    public RealVector subtract(RealVector v) {
        Entry e;
        RealVector result = v.copy();
        Iterator<Entry> it = this.sparseIterator();
        while (it.hasNext() && (e = it.next()) != null) {
            int index = e.getIndex();
            result.setEntry(index, e.getValue() - result.getEntry(index));
        }
        return result;
    }

    public RealVector mapAdd(double d) {
        return this.copy().mapAddToSelf(d);
    }

    public RealVector mapAddToSelf(double d) {
        if (d != 0.0) {
            return this.mapToSelf(FunctionUtils.fix2ndArgument(new Add(), d));
        }
        return this;
    }

    public abstract RealVector copy();

    public double dotProduct(RealVector v) {
        Entry e;
        this.checkVectorDimensions(v);
        double d = 0.0;
        Iterator<Entry> it = this.sparseIterator();
        while (it.hasNext() && (e = it.next()) != null) {
            d += e.getValue() * v.getEntry(e.getIndex());
        }
        return d;
    }

    public double cosine(RealVector v) {
        double norm = this.getNorm();
        double vNorm = v.getNorm();
        if (norm == 0.0 || vNorm == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        return this.dotProduct(v) / (norm * vNorm);
    }

    public abstract RealVector ebeDivide(RealVector var1);

    public abstract RealVector ebeMultiply(RealVector var1);

    public double getDistance(RealVector v) {
        Entry e;
        this.checkVectorDimensions(v);
        double d = 0.0;
        Iterator<Entry> it = this.iterator();
        while (it.hasNext() && (e = it.next()) != null) {
            double diff = e.getValue() - v.getEntry(e.getIndex());
            d += diff * diff;
        }
        return FastMath.sqrt(d);
    }

    public double getNorm() {
        Entry e;
        double sum = 0.0;
        Iterator<Entry> it = this.sparseIterator();
        while (it.hasNext() && (e = it.next()) != null) {
            double value = e.getValue();
            sum += value * value;
        }
        return FastMath.sqrt(sum);
    }

    public double getL1Norm() {
        Entry e;
        double norm = 0.0;
        Iterator<Entry> it = this.sparseIterator();
        while (it.hasNext() && (e = it.next()) != null) {
            norm += FastMath.abs(e.getValue());
        }
        return norm;
    }

    public double getLInfNorm() {
        Entry e;
        double norm = 0.0;
        Iterator<Entry> it = this.sparseIterator();
        while (it.hasNext() && (e = it.next()) != null) {
            norm = FastMath.max(norm, FastMath.abs(e.getValue()));
        }
        return norm;
    }

    public double getL1Distance(RealVector v) {
        Entry e;
        this.checkVectorDimensions(v);
        double d = 0.0;
        Iterator<Entry> it = this.iterator();
        while (it.hasNext() && (e = it.next()) != null) {
            d += FastMath.abs(e.getValue() - v.getEntry(e.getIndex()));
        }
        return d;
    }

    public double getLInfDistance(RealVector v) {
        Entry e;
        this.checkVectorDimensions(v);
        double d = 0.0;
        Iterator<Entry> it = this.iterator();
        while (it.hasNext() && (e = it.next()) != null) {
            d = FastMath.max(FastMath.abs(e.getValue() - v.getEntry(e.getIndex())), d);
        }
        return d;
    }

    public int getMinIndex() {
        int minIndex = -1;
        double minValue = Double.POSITIVE_INFINITY;
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (!(entry.getValue() <= minValue)) continue;
            minIndex = entry.getIndex();
            minValue = entry.getValue();
        }
        return minIndex;
    }

    public double getMinValue() {
        int minIndex = this.getMinIndex();
        return minIndex < 0 ? Double.NaN : this.getEntry(minIndex);
    }

    public int getMaxIndex() {
        int maxIndex = -1;
        double maxValue = Double.NEGATIVE_INFINITY;
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (!(entry.getValue() >= maxValue)) continue;
            maxIndex = entry.getIndex();
            maxValue = entry.getValue();
        }
        return maxIndex;
    }

    public double getMaxValue() {
        int maxIndex = this.getMaxIndex();
        return maxIndex < 0 ? Double.NaN : this.getEntry(maxIndex);
    }

    public RealVector mapMultiply(double d) {
        return this.copy().mapMultiplyToSelf(d);
    }

    public RealVector mapMultiplyToSelf(double d) {
        return this.mapToSelf(FunctionUtils.fix2ndArgument(new Multiply(), d));
    }

    public RealVector mapSubtract(double d) {
        return this.copy().mapSubtractToSelf(d);
    }

    public RealVector mapSubtractToSelf(double d) {
        return this.mapAddToSelf(-d);
    }

    public RealVector mapDivide(double d) {
        return this.copy().mapDivideToSelf(d);
    }

    public RealVector mapDivideToSelf(double d) {
        return this.mapToSelf(FunctionUtils.fix2ndArgument(new Divide(), d));
    }

    public RealMatrix outerProduct(RealVector v) {
        AbstractRealMatrix product = v instanceof SparseRealVector || this instanceof SparseRealVector ? new OpenMapRealMatrix(this.getDimension(), v.getDimension()) : new Array2DRowRealMatrix(this.getDimension(), v.getDimension());
        Iterator<Entry> thisIt = this.sparseIterator();
        Entry thisE = null;
        while (thisIt.hasNext() && (thisE = thisIt.next()) != null) {
            Iterator<Entry> otherIt = v.sparseIterator();
            Entry otherE = null;
            while (otherIt.hasNext() && (otherE = otherIt.next()) != null) {
                product.setEntry(thisE.getIndex(), otherE.getIndex(), thisE.getValue() * otherE.getValue());
            }
        }
        return product;
    }

    public abstract RealVector projection(RealVector var1);

    public void set(double value) {
        Iterator<Entry> it = this.iterator();
        Entry e = null;
        while (it.hasNext() && (e = it.next()) != null) {
            e.setValue(value);
        }
    }

    public double[] toArray() {
        int dim = this.getDimension();
        double[] values = new double[dim];
        for (int i = 0; i < dim; ++i) {
            values[i] = this.getEntry(i);
        }
        return values;
    }

    public RealVector unitVector() {
        RealVector copy = this.copy();
        copy.unitize();
        return copy;
    }

    public void unitize() {
        this.mapDivideToSelf(this.getNorm());
    }

    public Iterator<Entry> sparseIterator() {
        return new SparseEntryIterator();
    }

    public Iterator<Entry> iterator() {
        final int dim = this.getDimension();
        return new Iterator<Entry>(){
            private int i = 0;
            private Entry e = new Entry();

            @Override
            public boolean hasNext() {
                return this.i < dim;
            }

            @Override
            public Entry next() {
                this.e.setIndex(this.i++);
                return this.e;
            }

            @Override
            public void remove() {
                throw new MathUnsupportedOperationException();
            }
        };
    }

    public RealVector map(UnivariateFunction function) {
        return this.copy().mapToSelf(function);
    }

    public RealVector mapToSelf(UnivariateFunction function) {
        Entry e;
        Iterator<Entry> it;
        Iterator<Entry> iterator = it = function.value(0.0) == 0.0 ? this.sparseIterator() : this.iterator();
        while (it.hasNext() && (e = it.next()) != null) {
            e.setValue(function.value(e.getValue()));
        }
        return this;
    }

    public RealVector combine(double a, double b, RealVector y) {
        return this.copy().combineToSelf(a, b, y);
    }

    public RealVector combineToSelf(double a, double b, RealVector y) {
        this.checkVectorDimensions(y);
        for (int i = 0; i < this.getDimension(); ++i) {
            double xi = this.getEntry(i);
            double yi = y.getEntry(i);
            this.setEntry(i, a * xi + b * yi);
        }
        return this;
    }

    public static RealVector unmodifiableRealVector(final RealVector v) {
        return new RealVector(){

            @Override
            public RealVector mapToSelf(UnivariateFunction function) {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector map(UnivariateFunction function) {
                return v.map(function);
            }

            @Override
            public Iterator<Entry> iterator() {
                final Iterator<Entry> i = v.iterator();
                return new Iterator<Entry>(){
                    private final UnmodifiableEntry e;
                    {
                        this.e = new UnmodifiableEntry();
                    }

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Entry next() {
                        this.e.setIndex(((Entry)i.next()).getIndex());
                        return this.e;
                    }

                    @Override
                    public void remove() {
                        throw new MathUnsupportedOperationException();
                    }
                };
            }

            @Override
            public Iterator<Entry> sparseIterator() {
                final Iterator<Entry> i = v.sparseIterator();
                return new Iterator<Entry>(){
                    private final UnmodifiableEntry e;
                    {
                        this.e = new UnmodifiableEntry();
                    }

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Entry next() {
                        this.e.setIndex(((Entry)i.next()).getIndex());
                        return this.e;
                    }

                    @Override
                    public void remove() {
                        throw new MathUnsupportedOperationException();
                    }
                };
            }

            @Override
            public RealVector copy() {
                return v.copy();
            }

            @Override
            public RealVector add(RealVector w) {
                return v.add(w);
            }

            @Override
            public RealVector subtract(RealVector w) {
                return v.subtract(w);
            }

            @Override
            public RealVector mapAdd(double d) {
                return v.mapAdd(d);
            }

            @Override
            public RealVector mapAddToSelf(double d) {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector mapSubtract(double d) {
                return v.mapSubtract(d);
            }

            @Override
            public RealVector mapSubtractToSelf(double d) {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector mapMultiply(double d) {
                return v.mapMultiply(d);
            }

            @Override
            public RealVector mapMultiplyToSelf(double d) {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector mapDivide(double d) {
                return v.mapDivide(d);
            }

            @Override
            public RealVector mapDivideToSelf(double d) {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector ebeMultiply(RealVector w) {
                return v.ebeMultiply(w);
            }

            @Override
            public RealVector ebeDivide(RealVector w) {
                return v.ebeDivide(w);
            }

            @Override
            public double dotProduct(RealVector w) {
                return v.dotProduct(w);
            }

            @Override
            public double cosine(RealVector w) {
                return v.cosine(w);
            }

            @Override
            public double getNorm() {
                return v.getNorm();
            }

            @Override
            public double getL1Norm() {
                return v.getL1Norm();
            }

            @Override
            public double getLInfNorm() {
                return v.getLInfNorm();
            }

            @Override
            public double getDistance(RealVector w) {
                return v.getDistance(w);
            }

            @Override
            public double getL1Distance(RealVector w) {
                return v.getL1Distance(w);
            }

            @Override
            public double getLInfDistance(RealVector w) {
                return v.getLInfDistance(w);
            }

            @Override
            public RealVector unitVector() {
                return v.unitVector();
            }

            @Override
            public void unitize() {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector projection(RealVector w) {
                return v.projection(w);
            }

            @Override
            public RealMatrix outerProduct(RealVector w) {
                return v.outerProduct(w);
            }

            @Override
            public double getEntry(int index) {
                return v.getEntry(index);
            }

            @Override
            public void setEntry(int index, double value) {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public void addToEntry(int index, double value) {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public int getDimension() {
                return v.getDimension();
            }

            @Override
            public RealVector append(RealVector w) {
                return v.append(w);
            }

            @Override
            public RealVector append(double d) {
                return v.append(d);
            }

            @Override
            public RealVector getSubVector(int index, int n) {
                return v.getSubVector(index, n);
            }

            @Override
            public void setSubVector(int index, RealVector w) {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public void set(double value) {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public double[] toArray() {
                return v.toArray();
            }

            @Override
            public boolean isNaN() {
                return v.isNaN();
            }

            @Override
            public boolean isInfinite() {
                return v.isInfinite();
            }

            @Override
            public RealVector combine(double a, double b, RealVector y) {
                return v.combine(a, b, y);
            }

            @Override
            public RealVector combineToSelf(double a, double b, RealVector y) {
                throw new MathUnsupportedOperationException();
            }

            class UnmodifiableEntry
            extends Entry {
                UnmodifiableEntry() {
                }

                public double getValue() {
                    return v.getEntry(this.getIndex());
                }

                public void setValue(double value) {
                    throw new MathUnsupportedOperationException();
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SparseEntryIterator
    implements Iterator<Entry> {
        private final int dim;
        private Entry current;
        private Entry next;

        protected SparseEntryIterator() {
            this.dim = RealVector.this.getDimension();
            this.current = new Entry();
            this.next = new Entry();
            if (this.next.getValue() == 0.0) {
                this.advance(this.next);
            }
        }

        protected void advance(Entry e) {
            if (e == null) {
                return;
            }
            do {
                e.setIndex(e.getIndex() + 1);
            } while (e.getIndex() < this.dim && e.getValue() == 0.0);
            if (e.getIndex() >= this.dim) {
                e.setIndex(-1);
            }
        }

        @Override
        public boolean hasNext() {
            return this.next.getIndex() >= 0;
        }

        @Override
        public Entry next() {
            int index = this.next.getIndex();
            if (index < 0) {
                throw new NoSuchElementException();
            }
            this.current.setIndex(index);
            this.advance(this.next);
            return this.current;
        }

        @Override
        public void remove() {
            throw new MathUnsupportedOperationException();
        }
    }

    protected class Entry {
        private int index;

        public Entry() {
            this.setIndex(0);
        }

        public double getValue() {
            return RealVector.this.getEntry(this.getIndex());
        }

        public void setValue(double value) {
            RealVector.this.setEntry(this.getIndex(), value);
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

