/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.SaddlePointExpansion;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;

public class PoissonDistribution
extends AbstractIntegerDistribution {
    public static final int DEFAULT_MAX_ITERATIONS = 10000000;
    public static final double DEFAULT_EPSILON = 1.0E-12;
    private static final long serialVersionUID = -3349935121172596109L;
    private final NormalDistribution normal;
    private final double mean;
    private final int maxIterations;
    private final double epsilon;

    public PoissonDistribution(double p) throws NotStrictlyPositiveException {
        this(p, 1.0E-12, 10000000);
    }

    public PoissonDistribution(double p, double epsilon, int maxIterations) throws NotStrictlyPositiveException {
        if (p <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, p);
        }
        this.mean = p;
        this.normal = new NormalDistribution(p, FastMath.sqrt(p));
        this.epsilon = epsilon;
        this.maxIterations = maxIterations;
    }

    public PoissonDistribution(double p, double epsilon) throws NotStrictlyPositiveException {
        this(p, epsilon, 10000000);
    }

    public PoissonDistribution(double p, int maxIterations) {
        this(p, 1.0E-12, maxIterations);
    }

    public double getMean() {
        return this.mean;
    }

    public double probability(int x) {
        double ret = x < 0 || x == Integer.MAX_VALUE ? 0.0 : (x == 0 ? FastMath.exp(-this.mean) : FastMath.exp(-SaddlePointExpansion.getStirlingError(x) - SaddlePointExpansion.getDeviancePart(x, this.mean)) / FastMath.sqrt(Math.PI * 2 * (double)x));
        return ret;
    }

    public double cumulativeProbability(int x) {
        if (x < 0) {
            return 0.0;
        }
        if (x == Integer.MAX_VALUE) {
            return 1.0;
        }
        return Gamma.regularizedGammaQ((double)x + 1.0, this.mean, this.epsilon, this.maxIterations);
    }

    public double normalApproximateProbability(int x) {
        return this.normal.cumulativeProbability((double)x + 0.5);
    }

    public double getNumericalMean() {
        return this.getMean();
    }

    public double getNumericalVariance() {
        return this.getMean();
    }

    public int getSupportLowerBound() {
        return 0;
    }

    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public int sample() {
        return (int)FastMath.min(this.randomData.nextPoisson(this.mean), Integer.MAX_VALUE);
    }
}

