% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{print_val}
\alias{print_val}
\title{Print value(s)}
\usage{
print_val(val_name, val_value, val_unit, val_sf, prefix = "", suffix = "")
}
\arguments{
\item{val_name}{A character string specifying the text preceding the value
of the parameter to be displayed.}

\item{val_value}{A numeric value specifying the value of the parameter to
be displayed.}

\item{val_unit}{A character string specifying the text following the value
of the parameter to be displayed.}

\item{val_sf}{A positive integer specifying the number of significant
figures for the display of the limit.}

\item{prefix}{A character string at the beginning of the whole text. The
default is an empty string, i.e. \code{""}.}

\item{suffix}{A character string at the end of the whole text. The default
is an empty string, i.e. \code{""}.}
}
\value{
A single character string of the form \dQuote{val_name: val_value
(with the number of specified decimal places) val_unit}.
}
\description{
The function \code{print_val()} generates a character string for the purpose
to print a value on a plot (together with associated information).
}
\details{
The function \code{print_val()} generates a character string that
is based on the provided information. The string is used as label of a
corresponding graph element. For the number formatting, the
\code{\link[base]{sprintf}()} function from the \sQuote{\code{base}} package
is used. For concatenation of the various elements, the
\code{\link[base]{paste}()} function from the \sQuote{\code{base}} package
is used.
}
\seealso{
\code{\link[base]{formatC}}, \code{\link[base]{paste}}.
}
\keyword{internal}
