% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{explain_logreg}
\alias{explain_logreg}
\title{Explain a binary target using a logistic regression (glm).
Model chosen by AIC in a Stepwise Algorithm (\code{MASS::stepAIC()}).}
\usage{
explain_logreg(data, target, out = "tibble", ...)
}
\arguments{
\item{data}{A dataset}

\item{target}{Target variable (binary)}

\item{out}{Output of the function: "tibble" | "model"}

\item{...}{Further arguments}
}
\value{
Dataset with results (term, estimate, std.error, z.value, p.value)
}
\description{
Explain a binary target using a logistic regression (glm).
Model chosen by AIC in a Stepwise Algorithm (\code{MASS::stepAIC()}).
}
\examples{
\dontshow{if (rlang::is_installed("MASS")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data <- iris
data$is_versicolor <- ifelse(iris$Species == "versicolor", 1, 0)
data$Species <- NULL
explain_logreg(data, target = is_versicolor)
\dontshow{\}) # examplesIf}
}
