% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9-mod.R
\docType{methods}
\name{compare}
\alias{compare}
\alias{compare,ExprsArray-method}
\title{Compare \code{ExprsArray} Objects}
\usage{
compare(object, array.valid = NULL, colBy = "defineCase", cutoff = 0.05)

\S4method{compare}{ExprsArray}(object, array.valid = NULL,
  colBy = "defineCase", cutoff = 0.05)
}
\arguments{
\item{object}{The \code{ExprsArray} object used when comparing annotations.}

\item{array.valid}{A second \code{ExprsArray} object used when comparing
annotations. Optional. Exclude with \code{array.valid = NULL}.}

\item{colBy}{A character string. The annotation column against which to
compare all other annotation terms (i.e., to test as the independent
variable).}

\item{cutoff}{A numeric scalar. The p-value cutoff that determines when
the annotation test returns a \code{TRUE} result}
}
\value{
A list of three logical vectors. The first and second elements
 of the list correspond to "internal" comparisons for the two provided
 \code{ExprsArray} objects, respectively. The third element of the list
 corresponds to comparisons made between the provided objects.
}
\description{
This method compares the values of all \code{ExprsArray} annotations across a
 specified annotation term for up to two \code{ExprsArray} objects.
 Depending on the composition of each annotation, \code{compare}
 will perform either a chi-squared test or an ANOVA test.
}
\details{
This method performs two kinds of comparisons. First, it tests all
 annotation variables against the annotation supplied by the \code{colBy}
 argument for each provided \code{ExprsArray} object. In other words,
 the \code{colBy} argument determines which annotation to use as the
 independent variable for "internal" comparisons. Second, it tests
 all annotation variables between the provided \code{ExprsArray} objects.
 Providing \code{array.valid = NULL} will skip the between comparisons.

This method will test annotations using either a chi-squared test or an
 ANOVA test depending on the class of the values stored by the tested column.
 The presence of a "character" or "factor" in the tested column will trigger
 a chi-squared test. As such, this method requires the user to select
 a \code{colBy} annotation that contains categorical data (i.e., to use as
 the independent variable).

We anticipate that this method will serve as a useful adjunct to
 \code{\link{modCluster}}. However, it may also help in quickly determining
 whether the data \code{\link{split}} has yielded comparable training and
 test sets in terms of the annotations included in \code{@annot}.
}
\section{Methods (by class)}{
\itemize{
\item \code{ExprsArray}: Method to compare \code{ExprsArray} objects.
}}

