% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.3-exprso.R
\name{fs}
\alias{fs}
\title{Select Features}
\description{
The \code{exprso} package includes these feature selection modules:

- \code{\link{fsSample}}

- \code{\link{fsNULL}}

- \code{\link{fsANOVA}}

- \code{\link{fsInclude}}

- \code{\link{fsStats}}

- \code{\link{fsCor}}

- \code{\link{fsPrcomp}}

- \code{\link{fsEbayes}}

- \code{\link{fsEdger}}

- \code{\link{fsMrmre}}

- \code{\link{fsPropd}}
}
\details{
Considering the high-dimensionality of many datasets, it is prudent and
 often necessary to prioritize which features to include during model
 construction. This package provides functions for some of the most frequently
 used feature selection methods. Each function works as a self-contained wrapper
 that (1) pre-processes the \code{ExprsArray} input, (2) performs the feature
 selection, and (3) returns an \code{ExprsArray} output with an updated feature
 selection history. These histories get passed along at every step of the way
 until they eventually get used to pre-process an unlabeled dataset during
 model deployment (i.e., prediction).

The argument \code{top} specifies either the names or the number of features
 to supply TO the feature selection method, not what the user intends to
 retrieve FROM the feature selection method. When calling the first feature
 selection method (or the first build method, if skipping feature selection),
 a numeric \code{top} argument will select a "top ranked" feature set according
 to their default order in the \code{ExprsArray} input.
}
